/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.providers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.reqcycle.predicates.core.IPredicateEvaluator;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.ui.RequirementViewDisplayType;
import org.polarsys.reqcycle.repository.ui.navigator.NavigatorRoot;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StylingContentProvider
implements ITreeContentProvider {
    @Inject
    IPredicateEvaluator predicateEvaluator;
    private List<IPredicate> predicates;
    private List<Scope> scopes;
    private String reqFilter;
    private RequirementViewDisplayType displayType;
    private NavigatorRoot navigatorRoot;

    public StylingContentProvider() {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.predicates = new LinkedList<IPredicate>();
        this.scopes = new LinkedList<Scope>();
        this.displayType = RequirementViewDisplayType.NONE;
        this.reqFilter = "";
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof NavigatorRoot) {
            this.navigatorRoot = (NavigatorRoot)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof NavigatorRoot) {
            this.predicates = ((NavigatorRoot)inputElement).getPredicates();
            this.scopes = ((NavigatorRoot)inputElement).getScopes();
            this.reqFilter = ((NavigatorRoot)inputElement).getFilter();
            this.displayType = ((NavigatorRoot)inputElement).getDisplay();
            switch (this.displayType) {
                case FILTERBYNAME: {
                    if (this.reqFilter != null && !this.reqFilter.equals("")) {
                        final Pattern p = Pattern.compile(".*" + this.reqFilter + ".*", 32);
                        Predicate<Object> attPredicate = new Predicate<Object>(){

                            public boolean apply(Object arg0) {
                                if (arg0 instanceof Requirement) {
                                    Requirement req = (Requirement)arg0;
                                    return req.getId() != null && p.matcher(req.getId()).matches();
                                }
                                return true;
                            }
                        };
                        return Iterators.toArray((Iterator)Iterators.filter(((NavigatorRoot)inputElement).getSources().iterator(), (Predicate)attPredicate), Object.class);
                    }
                    List sources = ((NavigatorRoot)inputElement).getSources();
                    return sources.toArray();
                }
                case FILTERBYPREDICATE: {
                    if (this.predicates.size() == 1) {
                        IPredicate predicate = this.predicates.get(0);
                        return Iterators.toArray((Iterator)Iterators.filter(((NavigatorRoot)inputElement).getSources().iterator(), (Predicate)new PPredicate(predicate)), Object.class);
                    }
                    List sources = ((NavigatorRoot)inputElement).getSources();
                    return sources.toArray();
                }
                case ORDERBYPREDICATE: {
                    if (this.predicates.size() != 0) {
                        return this.predicates.toArray();
                    }
                    List sources = ((NavigatorRoot)inputElement).getSources();
                    return sources.toArray();
                }
                case ORDERBYSCOPE: {
                    if (this.scopes.size() != 0) {
                        return this.scopes.toArray();
                    }
                    List sources = ((NavigatorRoot)inputElement).getSources();
                    return sources.toArray();
                }
            }
            List sources = ((NavigatorRoot)inputElement).getSources();
            return sources.toArray();
        }
        return null;
    }

    public Object[] getChildren(Object object) {
        EList elements = Collections.emptyList();
        if (object instanceof RequirementSource) {
            RequirementSource requirementSource = (RequirementSource)object;
            if (this.displayType.equals((Object)RequirementViewDisplayType.FILTERBYPREDICATE) && this.predicates.size() == 1) {
                IPredicate predicate = this.predicates.get(0);
                return Iterators.toArray((Iterator)Iterators.filter((Iterator)requirementSource.getRequirements().iterator(), (Predicate)new PPredicate(predicate)), Object.class);
            }
            if (this.displayType.equals((Object)RequirementViewDisplayType.FILTERBYNAME)) {
                final Pattern p = Pattern.compile(".*" + this.reqFilter + ".*", 32);
                Predicate<Object> attPredicate = new Predicate<Object>(){

                    public boolean apply(Object arg0) {
                        if (arg0 instanceof Requirement) {
                            Requirement req = (Requirement)arg0;
                            return req.getId() != null && p.matcher(req.getId()).matches();
                        }
                        return false;
                    }
                };
                return Iterators.toArray((Iterator)Iterators.filter(new Source2Reqs().apply(requirementSource), (Predicate)attPredicate), Object.class);
            }
            if (this.displayType.equals((Object)RequirementViewDisplayType.REQONLY)) {
                return Iterators.toArray((Iterator)Iterators.concat((Iterator)Iterators.transform(Collections.singletonList(requirementSource).iterator(), (Function)new Source2Reqs())), Object.class);
            }
            elements = requirementSource.getRequirements();
        } else {
            if (object instanceof IPredicate) {
                return Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.transform(this.navigatorRoot.getSources().iterator(), (Function)new Source2Reqs())), (Predicate)new PPredicate((IPredicate)object)), Object.class);
            }
            if (object instanceof Section) {
                if (this.displayType.equals((Object)RequirementViewDisplayType.FILTERBYPREDICATE) && this.predicates.size() == 1) {
                    IPredicate predicate = this.predicates.get(0);
                    return Iterators.toArray((Iterator)Iterators.filter((Iterator)((Section)object).getChildren().iterator(), (Predicate)new PPredicate(predicate)), Object.class);
                }
                elements = ((Section)object).getChildren();
            } else if (object instanceof Scope) {
                return ((Scope)object).getRequirements().toArray();
            }
        }
        if (elements.size() != 0) {
            return Iterables.toArray((Iterable)elements, Object.class);
        }
        return null;
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof RequirementSource) {
            if (this.displayType.equals((Object)RequirementViewDisplayType.FILTERBYPREDICATE) && this.predicates.size() == 1) {
                IPredicate predicate = this.predicates.get(0);
                return Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.transform(Collections.singletonList((RequirementSource)object).iterator(), (Function)new Source2Reqs())), (Predicate)new PPredicate(predicate)).hasNext();
            }
            return !((RequirementSource)object).getRequirements().isEmpty();
        }
        if (object instanceof IPredicate) {
            return Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.transform(this.navigatorRoot.getSources().iterator(), (Function)new Source2Reqs())), (Predicate)new PPredicate((IPredicate)object)).hasNext();
        }
        if (object instanceof Section) {
            return !((Section)object).getChildren().isEmpty();
        }
        if (object instanceof Scope) {
            return !((Scope)object).getRequirements().isEmpty();
        }
        return false;
    }

    private class PPredicate
    implements Predicate<Object> {
        private IPredicate p;

        public PPredicate(IPredicate p) {
            this.p = p;
        }

        public boolean apply(Object arg0) {
            if (this.p == null) {
                return true;
            }
            if (arg0 instanceof RequirementSource) {
                for (AbstractElement elt : ((RequirementSource)arg0).getRequirements()) {
                    if (!(elt instanceof Section ? this.apply(elt) : StylingContentProvider.this.predicateEvaluator.match(this.p, (Object)elt))) continue;
                    return true;
                }
                return false;
            }
            if (arg0 instanceof Requirement) {
                return StylingContentProvider.this.predicateEvaluator.match(this.p, arg0);
            }
            if (arg0 instanceof Section) {
                for (AbstractElement elt : ((Section)arg0).getChildren()) {
                    if (!(elt instanceof Requirement ? StylingContentProvider.this.predicateEvaluator.match(this.p, (Object)elt) : this.apply(elt))) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private static class Source2Reqs
    implements Function<RequirementSource, Iterator<Requirement>> {
        private Source2Reqs() {
        }

        public Iterator<Requirement> apply(RequirementSource arg0) {
            Object result = Iterators.filter((Iterator)arg0.getRequirements().iterator(), Requirement.class);
            Iterator allChildren = Iterators.transform((Iterator)arg0.getRequirements().iterator(), (Function)new Function<AbstractElement, Iterator<EObject>>(){

                public Iterator<EObject> apply(AbstractElement arg0) {
                    return arg0.eAllContents();
                }
            });
            UnmodifiableIterator allReqChildren = Iterators.filter((Iterator)Iterators.concat((Iterator)allChildren), Requirement.class);
            result = Iterators.concat((Iterator)result, (Iterator)allReqChildren);
            return result;
        }
    }
}

