/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityAnalyserDisabler;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.builder.LabelledVisitor;
import org.polarsys.reqcycle.uri.visitors.CompositeVisitor;
import org.polarsys.reqcycle.uri.visitors.IVisitor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityVisitor
extends CompositeVisitor
implements IAdaptable {
    private static ITraceabilityAnalyserDisabler disabler = (ITraceabilityAnalyserDisabler)ZigguratInject.make(ITraceabilityAnalyserDisabler.class);
    private ITraceabilityBuilder.IBuilderCallBack callBack;

    public TraceabilityVisitor(ITraceabilityBuilder.IBuilderCallBack callBack) {
        super(TraceabilityVisitor.getTraceabilityVisitors());
        this.callBack = callBack;
    }

    private static Collection<IVisitor> getTraceabilityVisitors() {
        Iterable tmp = Iterables.filter((Iterable)Lists.newArrayList(LabelledVisitor.getRegisteredVisitors()), IVisitor.class);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)tmp, (Predicate)new Predicate<IVisitor>(){

            public boolean apply(IVisitor arg0) {
                Class<Object> classToCheck = arg0.getClass();
                if (arg0 instanceof LabelledVisitor) {
                    classToCheck = ((LabelledVisitor)arg0).getVisitorClass();
                }
                return disabler == null || !disabler.isDisabled(classToCheck);
            }
        }));
    }

    public boolean visit(Object o, IAdaptable adapable) {
        return super.visit(o, (IAdaptable)this);
    }

    public Object getAdapter(Class adapter) {
        if (ITraceabilityBuilder.IBuilderCallBack.class == adapter) {
            return this.callBack;
        }
        return null;
    }
}

