/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document.ocl.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.kitalpha.doc.doc2model.common.Common.DocumentModel;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.kitalpha.doc.doc2model.core.IContentHandler;
import org.polarsys.reqcycle.ocl.ui.SettingBean;
import org.polarsys.reqcycle.repository.connector.document.ocl.ui.OCLDocBean;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;

public class DocOclSettingPage
extends AbstractSettingPage {
    private Text txtSelectedDoc;
    private Button btnBrowseDoc;
    private ComboViewer cImportType;

    public DocOclSettingPage(SettingBean bean) {
        super("Document OCL Connector settings", (AbstractStorageBean)bean);
        this.setTitle("Connector DOCUMENT with OCL configuration: settings page");
        this.setDescription("Connector settings");
    }

    protected Composite doCreateSpecific(Composite compositeContainer) {
        compositeContainer.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)compositeContainer);
        Label lblDocFile = new Label(compositeContainer, 0);
        lblDocFile.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblDocFile.setText("Document :");
        this.txtSelectedDoc = new Text(compositeContainer, 2048);
        this.txtSelectedDoc.setEnabled(false);
        this.txtSelectedDoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnBrowseDoc = new Button(compositeContainer, 0);
        this.btnBrowseDoc.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnBrowseDoc.setText("Browse");
        Label lblType = new Label(compositeContainer, 0);
        lblType.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblType.setText("Import Type :");
        this.cImportType = new ComboViewer(compositeContainer);
        this.cImportType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cImportType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContentHandler) {
                    IContentHandler handler = (IContentHandler)element;
                    return handler.getLabel();
                }
                return super.getText(element);
            }
        });
        this.cImportType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)event.getSelection();
                    IContentHandler handler = (IContentHandler)structured.getFirstElement();
                    DocOclSettingPage.this.getBean().setHandlerClassName(handler.getClass().getName());
                }
            }
        });
        this.cImportType.setInput(Collections.emptyList());
        this.cImportType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        return compositeContainer;
    }

    protected void hookListeners() {
        super.hookListeners();
        this.getDestinationFileSelectionListener();
        this.btnBrowseDoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(DocOclSettingPage.this.getShell(), "Select a document", 0);
                if (dialog.open() == 0 && !(uris = dialog.getURIs()).isEmpty()) {
                    Doc2Model doc2Model = new Doc2Model();
                    String fileString = CommonPlugin.asLocalURI((URI)((URI)uris.get(0))).toFileString();
                    String fileType = doc2Model.getFileType(fileString);
                    if (fileType != null && fileType.toString() != null) {
                        DocOclSettingPage.this.txtSelectedDoc.setText(((URI)uris.get(0)).toString());
                        DocOclSettingPage.this.cImportType.setInput((Object)doc2Model.getContentHandlers(fileString, DocumentModel.class));
                    } else {
                        DocOclSettingPage.this.txtSelectedDoc.setText("");
                        DocOclSettingPage.this.setErrorMessage("Your document is not supported. Retry and choose document file");
                    }
                }
            }
        });
    }

    public boolean isPageComplete() {
        boolean result = super.isPageComplete();
        String msg = this.getErrorMessage();
        if (msg == null) {
            msg = "";
        }
        if (this.txtSelectedDoc.getText() == null || this.txtSelectedDoc.getText() == "") {
            result = false;
            msg = String.valueOf(msg) + "Choose a document Input\n";
        }
        if (!result) {
            this.setErrorMessage(msg);
        }
        return result;
    }

    protected void doSpecificInitDataBindings(DataBindingContext bindingContext) {
        ISWTObservableValue observeTextTxtSelectedDocObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSelectedDoc);
        IObservableValue uriBeanObserveValue = PojoProperties.value((String)"uri").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeTextTxtSelectedDocObserveWidget, uriBeanObserveValue, null, null);
    }

    public OCLDocBean getBean() {
        return (OCLDocBean)super.getBean();
    }
}

