/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.doc.doc2model.common.Common.ContentElement;
import org.polarsys.kitalpha.doc.doc2model.common.Common.DocumentModel;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Cell;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Row;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Section;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.SectionContents;
import org.polarsys.reqcycle.inittypes.inittypes.Requirement;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.document.DocParser;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocCallable
implements ICallable {
    @Inject
    IDataManager dataManager;
    protected DocParser parser = (DocParser)ZigguratInject.make(DocParser.class);
    private ArrayList<Section> sections;
    protected List<ContentElement> listContentElement;
    List<Requirement> listValideRequirements = new ArrayList<Requirement>();

    public void fillRequirementSource(RequirementSource source) {
        RequirementSource reqSource = source;
        this.parser.setDocument(this.getDocumentFromModele(reqSource));
        this.parser.setSections(this.sections);
        source.setDefaultScope(PropertyUtils.getScopeFromSource((RequirementSource)source));
        try {
            this.parser.run(source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String docFileName = reqSource.getRepositoryURI();
        String lastSegmentDocFileName = this.getLastSegment(docFileName);
        Set<IFile> files = this.getImageFilesForDoc(docFileName);
        String fullDestinationFileName = reqSource.getDestinationURI();
        String lastSegmentDestinationFileName = this.getLastSegment(fullDestinationFileName);
        for (IFile file : files) {
            String imageFileName = file.getFullPath().toString();
            String newImageFileName = imageFileName.replace(lastSegmentDocFileName, lastSegmentDestinationFileName);
            Path path = new Path(newImageFileName);
            try {
                file.refreshLocal(0, null);
                file.move((IPath)path, false, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private String getLastSegment(IFile file) {
        if (file == null) {
            return "";
        }
        return this.getLastSegment(file.getName());
    }

    private String getLastSegment(String path) {
        String lastName = path;
        StringTokenizer st = new StringTokenizer(path, "//");
        int nb = st.countTokens();
        int i = 0;
        while (i < nb) {
            lastName = st.nextToken();
            ++i;
        }
        return lastName;
    }

    private String removeTwoFirstSegments(String completePath) {
        String relativePath = completePath.substring(completePath.indexOf("/") + 1);
        relativePath = relativePath.substring(relativePath.indexOf("/") + 1);
        return relativePath;
    }

    private IFile getFileFromCompletePath(String completePath) {
        String relativePath = this.removeTwoFirstSegments(completePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(relativePath));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected Set<IFile> getImageFilesForDoc(String docFileName) {
        IFile docFile = this.getFileFromCompletePath(docFileName);
        HashSet<IFile> result = new HashSet<IFile>();
        if (docFile != null) {
            IResource[] docDirResources = new IResource[]{};
            try {
                IContainer docContainer = docFile.getParent();
                docDirResources = docContainer.members();
                String lastName = this.getLastSegment(docFile);
                IResource[] iResourceArray = docDirResources;
                int n = docDirResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    if (res.getName().startsWith(String.valueOf(lastName) + "_image") && res instanceof IFile) {
                        result.add((IFile)res);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setParser(DocParser parser) {
        this.parser = parser;
    }

    protected StringBuffer getDocumentFromModele(RequirementSource source) {
        StringBuffer doc = new StringBuffer();
        if (source.getRepositoryURI() != null) {
            URI docUri = URI.createURI((String)source.getRepositoryURI());
            String fileString = CommonPlugin.asLocalURI((URI)docUri).toFileString();
            Doc2Model doc2model = new Doc2Model();
            String fileType = doc2model.getFileType(fileString);
            this.sections = new ArrayList();
            if (fileType != null && fileType.length() > 0) {
                DocumentModel result = (DocumentModel)doc2model.transform(fileString, DocumentModel.class).getDocModel();
                if (result == null) {
                    return new StringBuffer("");
                }
                this.listContentElement = new ArrayList<ContentElement>();
                TreeIterator i = result.eAllContents();
                while (i.hasNext()) {
                    EObject e = (EObject)i.next();
                    if (e instanceof ContentElement && !(e instanceof SectionContents)) {
                        ContentElement content = (ContentElement)e;
                        this.listContentElement.add(content);
                        doc.append(content.getTextContent());
                    }
                    if (e instanceof SectionContents || e instanceof Row || e instanceof Cell) {
                        doc.append(" ");
                    }
                    if (!(e instanceof Section)) continue;
                    Section section = (Section)e;
                    this.sections.add(section);
                }
            }
        }
        return doc;
    }

    public void setListVReq(List<Requirement> listValideRequirements) {
        this.listValideRequirements = listValideRequirements;
    }
}

