/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.dialogs;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.util.PredicatesUtil;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class NewPredicateDialog
extends TitleAreaDialog {
    private DataBindingContext m_bindingContext;
    private Text text;
    private ComboViewer comboViewer;
    private IContentProvider comboContentProvider;
    private ILabelProvider comboILabelProvider;
    private IInputValidator validator;
    private PredicateBean bean = new PredicateBean();
    IPredicatesConfManager predicatesConfManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    private Combo combo;

    public NewPredicateDialog(Shell parentShell) {
        super(parentShell);
        this.validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return "Enter the name of the new predicate";
                }
                if (!Pattern.compile("\\w+[-\\w]*", 2).matcher(newText).matches()) {
                    return "The name of the predicate is not valid.";
                }
                if (NewPredicateDialog.this.predicatesConfManager.isPredicateNameAlreadyUsed(newText)) {
                    return "This predicate's name is already used.";
                }
                return null;
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(control, 64);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Predicate name");
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label.setFont(parent.getFont());
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPredicateDialog.this.validateInput();
            }
        });
        label = new Label(composite, 64);
        label.setText("Root Predicate");
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label.setFont(parent.getFont());
        this.comboViewer = new ComboViewer(composite, 8);
        this.combo = this.comboViewer.getCombo();
        this.combo.setLayout((Layout)new GridLayout());
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.comboContentProvider == null) {
            this.comboContentProvider = ArrayContentProvider.getInstance();
        }
        if (this.comboILabelProvider == null) {
            this.comboILabelProvider = new LabelProvider();
        }
        this.comboViewer.setContentProvider(this.comboContentProvider);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.comboILabelProvider);
        this.comboViewer.setInput((Object)PredicatesUtil.getDefaultPredicates());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewPredicateDialog.this.validateInput();
            }
        });
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryLabelProvider adapterLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return adapterLabelProvider.getText(element);
            }
        });
        NewPredicateDialog.applyDialogFont((Control)composite);
        new Label(composite, 0);
        new Label(composite, 0);
        this.m_bindingContext = this.initDataBindings();
        return composite;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null && this.text != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        if (this.comboViewer != null && this.comboViewer.getSelection().isEmpty()) {
            String msg = "Select a root predicate";
            errorMessage = errorMessage != null && !errorMessage.isEmpty() ? String.valueOf(errorMessage) + "\n" + msg : msg;
        }
        this.setErrorMessage(errorMessage);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(errorMessage == null);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0 && btn != null) {
            btn.setEnabled(false);
        }
        return btn;
    }

    public String getName() {
        return this.bean != null ? this.bean.getName() : null;
    }

    public IPredicate getRootPredicate() {
        return this.bean != null ? this.bean.getRootPredicate() : null;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        IObservableValue nameBeanObserveValue = PojoProperties.value((String)"name").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeTextTextObserveWidget, nameBeanObserveValue, null, null);
        IViewerObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboViewer);
        IObservableValue rootPredicateBeanObserveValue = PojoProperties.value((String)"rootPredicate").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeSingleSelectionComboViewer, rootPredicateBeanObserveValue, null, null);
        return bindingContext;
    }

    static class PredicateBean {
        private String name;
        private IPredicate rootPredicate;

        PredicateBean() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public IPredicate getRootPredicate() {
            return this.rootPredicate;
        }

        public void setRootPredicate(IPredicate rootPredicate) {
            this.rootPredicate = rootPredicate;
        }
    }
}

