/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.dialogs;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCustomDialog
extends Dialog
implements Listener {
    private String title;
    private String message;
    private final Object input;
    private IInputValidator validator;
    private Button okButton;
    private Text errorMessageText;
    private String errorMessage;

    public AbstractCustomDialog(Shell parentShell, String dialogTitle, String dialogMessage, Object initialInput, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.input = initialInput == null ? Collections.EMPTY_LIST.toArray() : initialInput;
        this.validator = validator;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(container, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.createCustomDialogArea(container);
        this.errorMessageText = new Text(container, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        AbstractCustomDialog.applyDialogFont((Control)container);
        return container;
    }

    protected abstract void createCustomDialogArea(Composite var1);

    public abstract Collection<Object> getSelectedItems();

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Text getErrorMessageText() {
        return this.errorMessageText;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected Button getOKButton() {
        return this.okButton;
    }

    protected Object getInput() {
        return this.input;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    protected void enableOkButton(boolean enable) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(enable);
        }
    }

    public void handleEvent(Event event) {
    }
}

