/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.tika.parser.microsoft.Cell;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class StylizedCell
implements Cell {
    private final String _text;
    private Type _type = Type.String;
    private boolean _bold = false;
    private short _fontColor;
    private short _fillColor;
    private short _fontSize;

    public boolean isBold() {
        return this._bold;
    }

    public short getFontColor() {
        return this._fontColor;
    }

    public short getFillColor() {
        return this._fillColor;
    }

    public short getFontSize() {
        return this._fontSize;
    }

    public StylizedCell(String text, ExtendedFormatRecord efr, FontRecord fr) {
        this(text, efr, fr, Type.String);
    }

    public StylizedCell(String text, ExtendedFormatRecord efr, FontRecord fr, Type type) {
        this._text = text;
        this._type = type;
        if (fr.getBoldWeight() == 700) {
            this._bold = true;
        }
        this._fillColor = efr.getFillForeground() == 64 ? (short)-1 : efr.getFillForeground();
        this._fontColor = fr.getColorPaletteIndex() == 8 ? (short)-1 : fr.getColorPaletteIndex();
        this._fontSize = (short)(fr.getFontHeight() / 20);
    }

    public StylizedCell(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    public Type getType() {
        return this._type;
    }

    public String toString() {
        return "Stylized Cell: " + this._text;
    }

    public void render(XHTMLContentHandler handler) throws SAXException {
        handler.characters(this._text);
    }

    public static enum Type {
        Number,
        Date,
        String,
        HyperLink;

    }
}

