/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.polarsys.reqcycle.predicates.core.IPredicatesAnnotationSources;
import org.polarsys.reqcycle.predicates.core.PredicatesFactory;
import org.polarsys.reqcycle.predicates.core.PredicatesPackage;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.api.ITypedPredicate;

public class PredicatesUtil
implements IPredicatesAnnotationSources {
    private PredicatesUtil() {
    }

    public static Collection<IPredicate> getDefaultPredicates() {
        ArrayList<IPredicate> predicates = new ArrayList<IPredicate>();
        for (EClassifier classifier : PredicatesPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || !PredicatesPackage.Literals.IPREDICATE.isSuperTypeOf(eClass = (EClass)classifier) || eClass.isInterface() || eClass.isAbstract()) continue;
            predicates.add((IPredicate)PredicatesFactory.eINSTANCE.create(eClass));
        }
        return predicates;
    }

    public static boolean isSubType(EAttribute attribute, Class<?> type) {
        if (attribute == null || type == null) {
            throw new NullPointerException("The attribute or the type cannot be null.");
        }
        EDataType dataType = null;
        try {
            dataType = (EDataType)attribute.getEType();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        Class attributeClass = dataType.getInstanceClass();
        if (attributeClass.isPrimitive()) {
            attributeClass = ClassUtils.primitiveToWrapper((Class)attributeClass);
        }
        boolean result = false;
        result = type.isPrimitive() ? attributeClass.isAssignableFrom(ClassUtils.primitiveToWrapper(type)) : attributeClass.isAssignableFrom(type);
        return result;
    }

    public static EAttribute getUserSpecificInputAttribute(ITypedPredicate<?> predicate) {
        EAttribute result = PredicatesUtil.getEAllAttributesAnnotatedBy(predicate.eClass(), "www.eclipse.org/reqcycle/predicates/specificUserInput").iterator().next();
        return result;
    }

    public static Collection<EAttribute> getEAllAttributesAnnotatedBy(EClass eClass, String annotationSource) {
        HashSet<EAttribute> attributes = new HashSet<EAttribute>();
        for (EClass c : PredicatesUtil.getEAllSuperTypes(eClass)) {
            attributes.addAll(PredicatesUtil.getEAttributesAnnotatedBy(c, annotationSource));
        }
        attributes.addAll(PredicatesUtil.getEAttributesAnnotatedBy(eClass, annotationSource));
        return attributes;
    }

    public static Collection<EAttribute> getEAttributesAnnotatedBy(EClass eClass, String annotationSource) {
        ArrayList<EAttribute> attributes = new ArrayList<EAttribute>();
        for (EAttribute attr : eClass.getEAllAttributes()) {
            if (attr.getEAnnotation(annotationSource) == null) continue;
            attributes.add(attr);
        }
        return attributes;
    }

    private static Set<EClass> getEAllSuperTypes(EClass eClass) {
        HashSet<EClass> superTypes = new HashSet<EClass>();
        superTypes.addAll((Collection<EClass>)eClass.getEAllSuperTypes());
        for (EClass c : eClass.getESuperTypes()) {
            if (c.getESuperTypes().isEmpty()) continue;
            superTypes.addAll(PredicatesUtil.getEAllSuperTypes(c));
        }
        return superTypes;
    }

    public static boolean isAdaptable(EAttribute attribute) {
        return attribute.getEAnnotation("www.eclipse.org/reqcycle/predicates/adaptInput") != null;
    }

    public static Class<?> getCastClassForInput(IPredicate predicate) {
        EAnnotation annotation = predicate.eClass().getEAnnotation("www.eclipse.org/reqcycle/predicates/input_javaclass_type");
        if (annotation != null) {
            String javaClassname = (String)annotation.getDetails().get((Object)"inputType");
            try {
                return Class.forName(javaClassname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Class<?> getObjectClassForInput(IPredicate predicate) {
        EAnnotation annotation = predicate.eClass().getEAnnotation("www.eclipse.org/reqcycle/predicates/input_javaclass_type");
        if (annotation != null) {
            String javaClassname = (String)annotation.getDetails().get((Object)"objectType");
            try {
                return Class.forName(javaClassname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

