/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.strategy.impl;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategy;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class IndexFunction
implements Function<AbstractElement, Integer> {
    static Cache<String, Pattern> patternCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    static Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[()\\[\\].+*?^$\\\\|]");
    IDataModelManager datamodelManager = (IDataModelManager)ZigguratInject.make(IDataModelManager.class);
    IRequirementNamingPreferenceManager prefManager = (IRequirementNamingPreferenceManager)ZigguratInject.make(IRequirementNamingPreferenceManager.class);
    static int val = 0;

    public Integer apply(AbstractElement arg0) {
        String id = arg0.getId();
        if (id == null) {
            return IStrategy.ERROR_VALUE;
        }
        IRequirementType type = this.datamodelManager.getType(arg0);
        if (type == null) {
            return IStrategy.ERROR_VALUE;
        }
        IDataModel datamodel = type.getDataModel();
        TypeConfiguration configuration = this.prefManager.getConfiguration(datamodel, (IType)type);
        if (configuration == null) {
            return IStrategy.ERROR_VALUE;
        }
        return this.findIndex(id, configuration.getPattern(), configuration.getDigits());
    }

    public static String escapeSpecialRegexChars(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    public Integer findIndex(String id, String pattern, Integer digits) {
        final String finalPattern = IndexFunction.escapeSpecialRegexChars(pattern).replaceAll("\\{index\\}", "(\\\\d*)").replaceAll("\\{.[^\\{]*\\}", "\\\\w*");
        try {
            Pattern pFinalPattern = (Pattern)patternCache.get((Object)finalPattern, (Callable)new Callable<Pattern>(){

                @Override
                public Pattern call() throws Exception {
                    return Pattern.compile(finalPattern);
                }
            });
            Matcher m = pFinalPattern.matcher(id);
            if (m.matches()) {
                int parseInt = Integer.parseInt(m.group(1));
                return parseInt;
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return IStrategy.ERROR_VALUE;
    }

    public static Iterable<AbstractElement> getAbstractElementChildren(EObject container) {
        if (container instanceof RequirementsContainer) {
            RequirementsContainer reqC = (RequirementsContainer)container;
            return reqC.getRequirements();
        }
        if (container instanceof Section) {
            Section section = (Section)container;
            return section.getChildren();
        }
        return Lists.newArrayList();
    }
}

