/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.providers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;

public class PreferenceDialogTypesContentProvider
extends AdapterFactoryContentProvider {
    @Inject
    private ITypesManager typesManager;
    private TypeConfigContainer container;

    public PreferenceDialogTypesContentProvider(AdapterFactory adapterFactory, TypeConfigContainer container) {
        super(adapterFactory);
        this.container = container;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof TypeConfigContainer) {
            return Lists.newArrayList((Iterable)Iterables.filter(Arrays.asList(super.getChildren(object)), (Predicate)new Predicate<Object>(){

                public boolean apply(Object o) {
                    boolean result;
                    boolean bl = result = !(o instanceof CustomType);
                    if (result && o instanceof Type) {
                        Type type = (Type)o;
                        return type.getIType() != null && type.getIType().getSuperType() == null;
                    }
                    return result;
                }
            })).toArray();
        }
        if (object instanceof Type) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Type type : this.container.getTypes()) {
                IType superType;
                if (type instanceof CustomType) {
                    CustomType cust = (CustomType)type;
                    if (cust.getSuperType() != object) continue;
                    list.add(cust);
                    continue;
                }
                if (type.getIType() == null || (superType = type.getIType().getSuperType()) == null || !superType.getId().equals(((Type)object).getTypeId())) continue;
                list.add(type);
            }
            return list.toArray();
        }
        return super.getChildren(object);
    }

    public void setTypeConfigContainer(TypeConfigContainer container) {
        if (container != null) {
            this.container = container;
        }
    }
}

