/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Entry;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationFactory;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class NewCustomTypeDialog
extends TitleAreaDialog {
    private CustomType newCustomType;
    private Text textName;
    @Inject
    ITypesManager manager;
    private IType injectedJavaType;
    private List<GenericEAttrPropsEditor> editors = Lists.newArrayList();

    public NewCustomTypeDialog(Shell parentShell, Type injected) {
        super(parentShell);
        this.setShellStyle(2160);
        this.newCustomType = TypeconfigurationFactory.eINSTANCE.createCustomType();
        this.newCustomType.setSuperType(injected);
    }

    @PostConstruct
    public void init() {
        IType javaType;
        this.injectedJavaType = javaType = this.newCustomType.getSuperType().getIType();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Configure a type");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText("Name :");
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewCustomTypeDialog.this.textName.getText().length() > 0) {
                    NewCustomTypeDialog.this.newCustomType.setTypeId(NewCustomTypeDialog.this.textName.getText());
                }
            }
        });
        Group grpParameters = new Group(container, 0);
        grpParameters.setLayout((Layout)new GridLayout(1, false));
        grpParameters.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        grpParameters.setText("Parameters");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)grpParameters, 2560);
        scrolledComposite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createEntries(composite);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        return area;
    }

    private void createEntries(Composite composite) {
        for (IType.FieldDescriptor d : this.injectedJavaType.getDescriptors()) {
            GenericEAttrPropsEditor editor = new GenericEAttrPropsEditor(composite, 0);
            if (d instanceof IType.FieldURIDescriptor) {
                IType.FieldURIDescriptor desc = (IType.FieldURIDescriptor)d;
                editor.init(d.name, desc.realType, Collections.emptyList());
            } else {
                editor.init(d.name, d.type, Collections.emptyList());
            }
            editor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.editors.add(editor);
        }
    }

    protected String getName(IType.FieldDescriptor d) {
        StringBuilder builder = new StringBuilder();
        char[] inChar = d.name.toCharArray();
        String currentWord = "";
        char[] cArray = inChar;
        int n = inChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                builder.append(currentWord).append(" ");
                currentWord = "";
                currentWord = String.valueOf(currentWord) + Character.toLowerCase(c);
            } else {
                currentWord = String.valueOf(currentWord) + c;
            }
            ++n2;
        }
        builder.append(currentWord);
        return builder.toString();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public CustomType getCustomType() {
        return this.newCustomType;
    }

    protected void okPressed() {
        if (this.newCustomType.getTypeId() == null || this.newCustomType.getTypeId().length() == 0) {
            this.setErrorMessage("Please set a name");
            return;
        }
        for (GenericEAttrPropsEditor a : this.editors) {
            Entry entry = TypeconfigurationFactory.eINSTANCE.createEntry();
            entry.setName(a.getAttributeName());
            entry.setValue(a.getEnteredValue());
            this.newCustomType.getEntries().add((Object)entry);
        }
        super.okPressed();
    }
}

