/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.impl.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.impl.handlers.StandardUtils;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.EmptyVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitable;

public class StandardReachableObject
implements ReachableObject {
    private Object object;

    public StandardReachableObject(Object object) {
        this.object = object;
    }

    public Object getAdapter(Class adapter) {
        if (ILabelProvider.class.equals((Object)adapter)) {
            return new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Reachable) {
                        Reachable reach = (Reachable)element;
                        return reach.getSchemeSpecificPart();
                    }
                    return super.getText(element);
                }
            };
        }
        if (IResource.class.equals((Object)adapter) || IFile.class.equals((Object)adapter)) {
            Reachable reachable = this.getReachable();
            String path = reachable.getPath();
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        return null;
    }

    @Override
    public IVisitable getVisitable() throws VisitableException {
        return new EmptyVisitable();
    }

    @Override
    public String getRevisionIdentification() {
        return null;
    }

    @Override
    public Reachable getReachable() {
        if (this.object instanceof Reachable) {
            return (Reachable)this.object;
        }
        return StandardUtils.getReachable(this.object);
    }
}

