/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.types.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.polarsys.reqcycle.types.Activator;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.impl.Type;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ExtensionPointReader {
    public static final ImageDescriptor DEFAULT_ICON = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("/icons/type.gif"));
    public static final String EXT_ID = "types";

    public Map<String, IType> read() {
        return Maps.uniqueIndex((Iterable)Iterables.filter((Iterable)Iterables.transform(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(Activator.PLUGIN_ID, EXT_ID)), (Function)new Conf2Type()), (Predicate)Predicates.notNull()), (Function)new Function<IType, String>(){

            public String apply(IType type) {
                return type != null ? type.getId() : "";
            }
        });
    }

    public class Conf2Type
    implements Function<IConfigurationElement, IType> {
        public IType apply(IConfigurationElement c) {
            Bundle bundle = Platform.getBundle((String)c.getContributor().getName());
            Type type = null;
            try {
                Class aClass = bundle.loadClass(c.getAttribute("checker"));
                type = new Type();
                ZigguratInject.inject((Object[])new Object[]{type});
                type.setChecker(aClass);
                String id = c.getAttribute("id");
                type.setId(id);
                String label = c.getAttribute("label");
                if (label == null || label.length() == 0) {
                    label = id;
                }
                type.setLabel(label);
                String icon = c.getAttribute("icon");
                ImageDescriptor desc = DEFAULT_ICON;
                if (icon != null && icon.length() >= 0) {
                    desc = ImageDescriptor.createFromURL((URL)bundle.getEntry(icon));
                }
                type.setIcon(desc);
                type.setSubTypeOf(c.getAttribute("subTypeOf"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return type;
        }
    }
}

