/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.ModelEditorPartListener;
import org.eclipse.viatra.query.tooling.ui.util.IModelConnectorListener;

public class EMFModelConnector
implements IModelConnector {
    private static final String LISTENER_NULL_MSG = "Listener cannot be null!";
    protected IEditorPart editorPart;
    protected ILog logger = ViatraQueryGUIPlugin.getDefault().getLog();
    protected IWorkbenchPage workbenchPage;
    private ModelEditorPartListener modelEditorPartListener;
    private Set<IModelConnectorListener> listeners;

    public EMFModelConnector(IEditorPart editorPart) {
        this.editorPart = editorPart;
        this.listeners = new HashSet<IModelConnectorListener>();
    }

    @Override
    public void loadModel(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        Notifier notifier = this.getNotifier(modelConnectorTypeEnum);
        if (notifier != null) {
            this.workbenchPage = this.editorPart.getSite().getPage();
            this.modelEditorPartListener = new ModelEditorPartListener(this);
            this.workbenchPage.addPartListener((IPartListener)this.modelEditorPartListener);
        }
    }

    @Override
    public void unloadModel() {
        for (IModelConnectorListener listener : this.listeners) {
            listener.modelUnloaded(this);
        }
        this.workbenchPage.removePartListener((IPartListener)this.modelEditorPartListener);
    }

    @Override
    public void showLocation(Object[] locationObjects) {
        TreeSelection preparedSelection = this.prepareSelection(locationObjects);
        this.navigateToElements(this.editorPart, (IStructuredSelection)preparedSelection);
        this.workbenchPage.bringToTop((IWorkbenchPart)this.editorPart);
        if (this.editorPart instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.editorPart;
            selectionProvider.setSelection((ISelection)preparedSelection);
        }
        this.reflectiveSetSelection(this.editorPart, (IStructuredSelection)preparedSelection);
    }

    @Override
    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        ISelectionProvider selectionProvider;
        ResourceSet result = null;
        if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof IEditingDomainProvider) {
                IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)this.editorPart;
                result = editingDomainProvider.getEditingDomain().getResourceSet();
            }
        } else if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum) && this.editorPart instanceof ISelectionProvider && (selectionProvider = (ISelectionProvider)this.editorPart).getSelection() instanceof TreeSelection) {
            Object object = ((TreeSelection)selectionProvider.getSelection()).getFirstElement();
            if (object instanceof Resource) {
                result = (Resource)object;
            } else if (object instanceof EObject) {
                result = ((EObject)object).eResource();
            }
        }
        return result;
    }

    private void reflectiveSetSelection(IEditorPart editorPart, IStructuredSelection preparedSelection) {
        if (editorPart instanceof IViewerProvider && ((IViewerProvider)editorPart).getViewer() instanceof TreeViewer) {
            try {
                Method m = editorPart.getClass().getMethod("setSelectionToViewer", Collection.class);
                if (m != null) {
                    m.invoke((Object)editorPart, preparedSelection.toList());
                }
            }
            catch (Exception e) {
                this.logger.log((IStatus)new Status(1, "org.eclipse.viatra.query.tooling.ui", "Error while setting selection. If this is not an EMF Tree editor, consider providing a specialized ModelConnector implementation.", (Throwable)e));
            }
        }
    }

    protected TreeSelection prepareSelection(Object[] locationObjects) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        Object[] objectArray = locationObjects;
        int n = locationObjects.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path;
            Object o = objectArray[n2];
            if (o instanceof EObject && (path = this.createTreePath(this.editorPart, (EObject)o)) != null) {
                paths.add(path);
            }
            ++n2;
        }
        return paths.isEmpty() ? new TreeSelection() : new TreeSelection(paths.toArray(new TreePath[1]));
    }

    protected void navigateToElements(IEditorPart editorPart, IStructuredSelection selection) {
        ISelectionProvider selectionProvider = editorPart.getSite().getSelectionProvider();
        selectionProvider.setSelection((ISelection)selection);
    }

    protected TreePath createTreePath(IEditorPart editorPart, EObject obj) {
        LinkedList<EObject> nodes = new LinkedList<EObject>();
        nodes.add(obj);
        EObject tmp = obj.eContainer();
        while (tmp != null) {
            nodes.add(0, tmp);
            tmp = tmp.eContainer();
        }
        return new TreePath(nodes.toArray());
    }

    @Override
    public IWorkbenchPart getOwner() {
        return this.editorPart;
    }

    @Override
    public Collection<EObject> getSelectedEObjects() {
        return this.getSelectedEObjects(this.getCurrentSelection());
    }

    protected ISelection getCurrentSelection() {
        ISelectionProvider selectionProvider = this.editorPart.getSite().getSelectionProvider();
        return selectionProvider.getSelection();
    }

    protected Collection<EObject> getSelectedEObjects(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            UnmodifiableIterator selectionIterator = Iterators.filter((Iterator)((IStructuredSelection)selection).iterator(), EObject.class);
            return Lists.newArrayList((Iterator)selectionIterator);
        }
        return Collections.emptyList();
    }

    public boolean addListener(IModelConnectorListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)LISTENER_NULL_MSG);
        return this.listeners.add(listener);
    }

    public boolean removeListener(IModelConnectorListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)LISTENER_NULL_MSG);
        return this.listeners.remove(listener);
    }
}

