/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import org.eclipse.ui.IViewPart;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.AbstractBackendSelectionControl;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class BackendSelectionControl extends AbstractBackendSelectionControl {
  @Override
  protected QueryEvaluationHint getHints() {
    final IViewPart resultView = this.getWorkbenchWindow().getActivePage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final QueryResultView queryResultView = ((QueryResultView) resultView);
      return queryResultView.getHint();
    }
    return null;
  }
  
  @Override
  protected void setHints(final QueryEvaluationHint newHint) {
    final IViewPart resultView = this.getWorkbenchWindow().getActivePage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final QueryResultView queryResultView = ((QueryResultView) resultView);
      queryResultView.setHint(newHint);
    }
  }
}
