/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.sources;

import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class ListContentProvider
extends AbstractViewerStateListener
implements IStructuredContentProvider {
    AbstractListViewer viewer;
    ViewerState state;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof AbstractListViewer));
        this.viewer = (AbstractListViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener(this);
        }
        if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            if (this.state.isDisposed()) {
                this.state = null;
            } else {
                this.state.addStateListener(this);
            }
        } else if (newInput != null) {
            throw new IllegalArgumentException(String.format("Invalid input type %s for List Viewer.", newInput.getClass().getName()));
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.state == null) {
            return new Object[0];
        }
        return this.state.getItems().toArray(new Item[this.state.getItems().size()]);
    }

    @Override
    public void itemAppeared(Item item) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.add((Object)item));
    }

    @Override
    public void itemDisappeared(Item item) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.remove((Object)item));
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener(this);
        }
    }
}

