/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViatraViewersPartSupport;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;

public abstract class ViatraViewersViewSupport
extends ViatraViewersPartSupport {
    protected IModelConnectorTypeEnum connectorType = IModelConnectorTypeEnum.RESOURCESET;
    protected ViewerState state;
    protected boolean delayUpdates = false;
    protected List<Object> currentSelection;
    protected final String ownerID;
    protected final IPartListener2 partListener = new IPartListener2(){

        private void updateModel() {
            if (ViatraViewersViewSupport.this.currentSelection != null) {
                ViatraViewersViewSupport.this.unbindModel();
                if (!ViatraViewersViewSupport.this.disposed) {
                    Display display = ViatraViewersViewSupport.this.owner.getSite().getShell().getDisplay();
                    display.asyncExec(() -> BusyIndicator.showWhile((Display)display, ViatraViewersViewSupport.this::doUpdateDisplay));
                }
            }
            ViatraViewersViewSupport.this.delayUpdates = false;
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                this.updateModel();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                this.updateModel();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                ViatraViewersViewSupport.this.delayUpdates = true;
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                this.updateModel();
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                ViatraViewersViewSupport.this.delayUpdates = true;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (Objects.equals(partRef.getId(), ViatraViewersViewSupport.this.ownerID)) {
                this.updateModel();
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    protected EMFScope modelSource;
    private Composite parent;
    private Composite cover;
    private Control contents;
    private StackLayout layout;

    public ViatraViewersViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope) {
        super((IWorkbenchPart)_owner, _config);
        this.connectorType = _scope;
        this.ownerID = _owner.getViewSite().getId();
        _owner.getViewSite().getPage().addPartListener(this.partListener);
    }

    protected IViewPart getOwner() {
        return (IViewPart)this.owner;
    }

    @Override
    public void dispose() {
        this.getOwner().getViewSite().getPage().removePartListener(this.partListener);
        this.unbindModel();
        super.dispose();
    }

    @Override
    protected void onSelectionChanged(List<Object> objects) {
        if (Objects.equals(objects, this.currentSelection)) {
            return;
        }
        this.currentSelection = objects;
        if (!this.delayUpdates) {
            this.doUpdateDisplay();
        }
    }

    protected void doUpdateDisplay() {
        if (this.disposed) {
            return;
        }
        EMFScope target = this.extractModelSource(this.currentSelection);
        if (target != null && !target.equals((Object)this.modelSource)) {
            this.unsetModelSource();
            this.setModelSource(target);
        }
    }

    protected EMFScope extractModelSource(List<Object> objects) {
        ImmutableSet notifiers = ImmutableSet.copyOf((Iterable)Iterables.filter(objects, Notifier.class));
        switch (this.connectorType) {
            default: {
                Iterator iterator = notifiers.iterator();
                if (!iterator.hasNext()) break;
                Notifier n = (Notifier)iterator.next();
                if (n instanceof ResourceSet) {
                    return new EMFScope(n);
                }
                if (n instanceof Resource) {
                    return new EMFScope((Notifier)((Resource)n).getResourceSet());
                }
                EObject eO = (EObject)n;
                return new EMFScope((Notifier)eO.eResource().getResourceSet());
            }
            case RESOURCE: {
                for (Notifier n : notifiers) {
                    if (n instanceof ResourceSet) continue;
                    if (n instanceof Resource) {
                        return new EMFScope((Notifier)((Resource)n));
                    }
                    EObject eO = (EObject)n;
                    return new EMFScope((Notifier)eO.eResource());
                }
            }
        }
        return new EMFScope((Set)notifiers, new BaseIndexOptions());
    }

    private void setModelSource(EMFScope p) {
        this.modelSource = p;
        this.bindModel();
        this.showView();
    }

    private void unsetModelSource() {
        this.hideView();
        this.unbindModel();
        this.modelSource = null;
    }

    protected ViatraQueryEngine getEngine() {
        Assert.isNotNull((Object)this.modelSource);
        return ViatraQueryEngine.on((QueryScope)this.modelSource);
    }

    public void createPartControl(Composite _parent, Control _contents) {
        this.parent = _parent;
        this.layout = new StackLayout();
        this.parent.setLayout((Layout)this.layout);
        this.contents = _contents;
        this.cover = new Composite(this.parent, 16);
        this.layout.topControl = this.cover;
        this.init();
    }

    private void showView() {
        this.layout.topControl = this.contents;
        this.parent.layout();
    }

    private void hideView() {
        this.layout.topControl = this.cover;
        this.parent.layout();
    }

    protected abstract void bindModel();

    protected abstract void unbindModel();
}

