/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.ArrangeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.ArrangeMenuManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.ArrangeBorderNodesAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.DiagramActionContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class TabbarArrangeMenuManager
extends ArrangeMenuManager
implements ISelectionListener {
    private IWorkbenchPart representationPart;

    public TabbarArrangeMenuManager(IDiagramWorkbenchPart iDiagramWorkbenchPart) {
        this.representationPart = iDiagramWorkbenchPart;
        EclipseUIUtil.addSelectionListener((IWorkbenchPart)this.representationPart, (ISelectionListener)this);
    }

    public void add(IAction action) {
        if (action instanceof DiagramAction) {
            this.add((IContributionItem)new DiagramActionContributionItem((DiagramAction)action));
        } else {
            this.add((IContributionItem)new ActionContributionItem(action));
        }
        if (action instanceof IDisposableAction) {
            ((IDisposableAction)action).init();
        }
    }

    protected void itemRemoved(IContributionItem item) {
        IAction action;
        if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof IDisposableAction) {
            ((IDisposableAction)action).dispose();
        }
    }

    public void dispose() {
        if (this.representationPart != null) {
            EclipseUIUtil.removeSelectionListener((IWorkbenchPart)this.representationPart, (ISelectionListener)this);
        }
        this.removeAll();
        this.representationPart = null;
        super.dispose();
    }

    public void setDefaultAction(String actionId) {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && actionId.equals(((ActionContributionItem)item).getAction().getId())) {
                IAction defaultAction = ((ActionContributionItem)item).getAction();
                this.setHandler(defaultAction);
                super.setDefaultAction(defaultAction);
                return;
            }
            ++n2;
        }
    }

    private void setHandler(IAction defaultAction) {
        try {
            Method method = ActionMenuManager.MenuCreatorAction.class.getDeclaredMethod("setActionHandler", IAction.class);
            method.setAccessible(true);
            method.invoke((Object)this.action, defaultAction);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null && this.representationPart != null && this.representationPart.equals(part)) {
            this.refreshArrangeMenu(page, selection);
        }
    }

    private void refreshArrangeMenu(IWorkbenchPage page, ISelection selection) {
        Object firstElement;
        boolean arrangeSelection = false;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IGraphicalEditPart && !(firstElement instanceof DDiagramEditPart)) {
            arrangeSelection = true;
        }
        if (arrangeSelection) {
            if (!this.isArrangeSelection()) {
                this.removeArrangeActions();
                ArrangeAction toolbarArrangeSelectionAction = ArrangeAction.createToolbarArrangeSelectionAction((IWorkbenchPage)page);
                this.add((IAction)toolbarArrangeSelectionAction);
                this.disableArrangeSelectionIfNotSupported(toolbarArrangeSelectionAction, (IStructuredSelection)selection);
                this.setDefaultAction(toolbarArrangeSelectionAction.getId());
            }
        } else if (!this.isArrangeAllAndBorderNodes()) {
            this.removeArrangeActions();
            ArrangeAction toolbarArrangeAllAction = ArrangeAction.createToolbarArrangeAllAction((IWorkbenchPage)page);
            this.add((IAction)toolbarArrangeAllAction);
            ArrangeBorderNodesAction toolBarArrangeBorderNodesAction = ArrangeBorderNodesAction.createToolBarArrangeBorderNodesAction(page);
            this.add((IAction)toolBarArrangeBorderNodesAction);
            this.setDefaultAction(toolbarArrangeAllAction.getId());
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            this.refreshArrangeMenu(page, page.getSelection());
            if (visible && this.representationPart == null) {
                this.representationPart = page.getActivePart();
                if (this.representationPart != null) {
                    EclipseUIUtil.addSelectionListener((IWorkbenchPart)this.representationPart, (ISelectionListener)this);
                }
            }
        }
    }

    private void removeArrangeActions() {
        this.remove("toolbarArrangeSelectionAction");
        this.remove("toolbarArrangeAllAction");
        this.remove("arrangeBorderNodesActionToolBar");
    }

    private boolean isArrangeSelection() {
        return this.find("toolbarArrangeSelectionAction") != null;
    }

    private boolean isArrangeAllAndBorderNodes() {
        return this.find("toolbarArrangeAllAction") != null && this.find("arrangeBorderNodesActionToolBar") != null;
    }

    private void disableArrangeSelectionIfNotSupported(ArrangeAction createToolbarArrangeSelectionAction, IStructuredSelection selection) {
        IGraphicalEditPart diagramEditPart;
        AbstractLayoutEditPartProvider layoutNodeProvider;
        RootEditPart root;
        IGraphicalEditPart graphicalElement = null;
        Iterator iterator = selection.iterator();
        while (iterator.hasNext() && graphicalElement == null) {
            Object next = iterator.next();
            if (!(next instanceof IGraphicalEditPart)) continue;
            graphicalElement = (IGraphicalEditPart)next;
            break;
        }
        if (graphicalElement != null && graphicalElement.isActive() && graphicalElement.getRoot() != null && !(root = graphicalElement.getRoot()).getChildren().isEmpty() && root.getChildren().iterator().next() instanceof IGraphicalEditPart && (layoutNodeProvider = LayoutService.getProvider(diagramEditPart = (IGraphicalEditPart)root.getChildren().iterator().next()).getLayoutNodeProvider(diagramEditPart)) instanceof ArrangeAllOnlyLayoutProvider) {
            createToolbarArrangeSelectionAction.setEnabled(false);
        }
    }
}

