/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.EdgeTargetQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class ToggleFoldingStateCommand
extends RecordingCommand {
    private final IDiagramElementEditPart part;
    private boolean folding;

    public ToggleFoldingStateCommand(TransactionalEditingDomain domain, IDiagramElementEditPart part) {
        super(domain, Messages.ToggleFoldingStateCommand_label);
        this.part = part;
    }

    protected void doExecute() {
        EdgeTarget startingPoint = this.getStartingPoint();
        if (startingPoint != null) {
            this.toggleFoldingState(startingPoint);
        }
    }

    private void toggleFoldingState(EdgeTarget startingPoint) {
        EdgeTargetQuery.FoldingState currentState = new EdgeTargetQuery(startingPoint).getFoldingState();
        this.folding = currentState == EdgeTargetQuery.FoldingState.UNFOLDED;
        HashSet handledElements = Sets.newHashSet((Object[])new DDiagramElement[]{(DDiagramElement)startingPoint});
        Iterable<DEdge> allFoldables = new EdgeTargetQuery(startingPoint).getAllFoldableEdges();
        for (DEdge edge : allFoldables) {
            if (new DDiagramElementQuery((DDiagramElement)edge).isExplicitlyFolded() == this.folding) continue;
            this.setEdgeFoldingPointState(edge);
            handledElements.add(edge);
            this.setAccessibleElementsState(edge, handledElements);
        }
    }

    private void setAccessibleElementsState(DEdge edge, Set<DDiagramElement> handledElements) {
        this.setEdgeFoldedState(edge);
        handledElements.add((DDiagramElement)edge);
        EdgeTarget elementToHandle = new DEdgeQuery(edge).getFoldingTarget();
        if (!handledElements.contains(elementToHandle)) {
            this.setElementFoldedState((DDiagramElement)elementToHandle);
            handledElements.add((DDiagramElement)elementToHandle);
            for (DEdge nextEdge : new EdgeTargetQuery(elementToHandle).getFoldableEdgesToFollow()) {
                this.setAccessibleElementsState(nextEdge, handledElements);
            }
        }
    }

    private void setEdgeFoldingPointState(DEdge edge) {
        if (this.folding) {
            this.addFilterType((DDiagramElement)edge, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingPointFilter());
        } else {
            this.removeFilterType((DDiagramElement)edge, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingPointFilter());
        }
    }

    private void setEdgeFoldedState(DEdge edge) {
        if (this.folding) {
            if (!new DDiagramElementQuery((DDiagramElement)edge).isExplicitlyFolded()) {
                this.addFilterType((DDiagramElement)edge, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingFilter());
            }
        } else {
            this.removeFilterType((DDiagramElement)edge, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingFilter());
        }
    }

    private void setElementFoldedState(DDiagramElement element) {
        if (this.folding) {
            this.addFilterType(element, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingFilter());
        } else {
            this.removeFilterType(element, (GraphicalFilter)DiagramFactory.eINSTANCE.createFoldingFilter());
        }
    }

    private void addFilterType(DDiagramElement element, GraphicalFilter filter) {
        if (!Iterables.any((Iterable)element.getGraphicalFilters(), (Predicate)Predicates.instanceOf(filter.getClass()))) {
            element.getGraphicalFilters().add((Object)filter);
        }
    }

    private void removeFilterType(DDiagramElement element, GraphicalFilter filter) {
        Iterator iter = element.getGraphicalFilters().iterator();
        while (iter.hasNext()) {
            GraphicalFilter gf = (GraphicalFilter)iter.next();
            if (!filter.eClass().isInstance((Object)gf)) continue;
            iter.remove();
        }
    }

    private EdgeTarget getStartingPoint() {
        DDiagramElement element = this.part.resolveDiagramElement();
        if (element instanceof EdgeTarget) {
            return (EdgeTarget)element;
        }
        return null;
    }
}

