/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui.cnf;

import org.eclipse.reddeer.common.adaptable.RedDeerAdaptable;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.condition.WidgetIsDisposed;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.eclipse.condition.ServerModuleHasState;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ModuleLabel;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.MenuItemIsEnabled;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public class ServerModule
implements RedDeerAdaptable<ServerModule> {
    private static final Logger log = Logger.getLogger(ServerModule.class);
    protected TreeItem treeItem;
    protected ServersView2 view;

    protected ServerModule(TreeItem item, ServersView2 view) {
        if (item == null) {
            throw new IllegalArgumentException("item can't be null");
        }
        this.treeItem = item;
        this.view = view;
    }

    public ModuleLabel getLabel() {
        this.select();
        return new ModuleLabel(this.treeItem);
    }

    public void remove() {
        this.select();
        if (this.treeItem == null) {
            throw new EclipseLayerException("ServerModule was already removed");
        }
        log.info("Remove server module with name '" + this.getLabel().getName() + "'");
        new WaitUntil((WaitCondition)new MenuItemIsEnabled((MenuItem)new ShellMenuItem(new String[]{"Edit", "Delete"})), TimePeriod.LONG);
        new ShellMenuItem(new String[]{"Edit", "Delete"}).select();
        DefaultShell serverShell = new DefaultShell("Server");
        new PushButton("OK").click();
        new GroupWait(new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable((Shell)serverShell)), WaitProvider.waitWhile((WaitCondition)new JobIsRunning()), WaitProvider.waitUntil((WaitCondition)new WidgetIsDisposed(this.treeItem.getSWTWidget()))});
        this.treeItem = null;
        WithTextMatcher shellMatcher = new WithTextMatcher((Matcher)new RegexMatcher("Publishing to .*"));
        new WaitUntil((WaitCondition)new ShellIsAvailable(new Matcher[]{shellMatcher}), TimePeriod.DEFAULT, false);
        new WaitWhile((WaitCondition)new ShellIsAvailable(new Matcher[]{shellMatcher}), TimePeriod.LONG);
    }

    protected void activate() {
        this.view.activate();
    }

    public void select() {
        this.activate();
        this.treeItem.select();
    }

    public boolean canStart() {
        this.select();
        return new ContextMenuItem(new String[]{"Start"}).isEnabled();
    }

    public boolean canRestart() {
        this.select();
        return new ContextMenuItem(new String[]{"Restart"}).isEnabled();
    }

    public boolean canStop() {
        this.select();
        return new ContextMenuItem(new String[]{"Stop"}).isEnabled();
    }

    public void start() {
        log.info("Start server module with name '" + this.getLabel().getName() + "'");
        this.select();
        new ContextMenuItem(new String[]{"Start"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitUntil((WaitCondition)new ServerModuleHasState(this, ServersViewEnums.ServerState.STARTED));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void stop() {
        log.info("Stop server module with name '" + this.getLabel().getName() + "'");
        this.select();
        new ContextMenuItem(new String[]{"Stop"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitUntil((WaitCondition)new ServerModuleHasState(this, ServersViewEnums.ServerState.STOPPED));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public void restart() {
        log.info("Restart server module with name '" + this.getLabel().getName() + "'");
        this.select();
        new ContextMenuItem(new String[]{"Restart"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitUntil((WaitCondition)new ServerModuleHasState(this, ServersViewEnums.ServerState.STARTED));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public Object[] getAdapterConstructorArguments() {
        Object[] args = new Object[]{this.treeItem, this.view};
        return args;
    }

    public Class<?>[] getAdapterConstructorClasses() {
        Class[] classes = new Class[]{TreeItem.class, ServersView2.class};
        return classes;
    }
}

