/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.dltk.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.dltk.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.BasicPHPWizardPage;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.PHPFullPathLabelProvider;
import org.eclipse.php.internal.ui.wizards.types.StatusLineLabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;

public abstract class NewPHPTypePage
extends BasicPHPWizardPage
implements IDialogFieldListener {
    private static final String BIND_NAMESPACE_AND_LOCATION = "Bind namespace and location";
    public static final String REQUIRE_ONCE = "require_once";
    public static final String TODOS = "TODOs";
    public static final String PHP_DOC_BLOCKS = "PHPDoc Blocks";
    public static final String DESTRUCTOR = "Destructor";
    public static final String CONSTRUCTOR = "Constructor";
    public static final String INHERITED_ABSTRACT_METHODS = "Inherited abstract methods";
    private static final Pattern PHP_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*");
    protected PHPVersion phpVersion;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    public static final int TRAIT_TYPE = 3;
    public static final int VALIDATE_SOURCE_FOLDER = 1;
    protected StatusInfo sourceFolderStatus;
    public static final int VALIDATE_NEW_FILE = 2;
    protected StatusInfo newFileStatus;
    public static final int VALIDATE_EXISTING_FILE = 3;
    protected StatusInfo existingFileStatus;
    public static final int VALIDATE_ELEMENT_NAME = 4;
    protected StatusInfo elementNameStatus;
    public static final int VALIDATE_NAMESPACE = 5;
    protected StatusInfo namespaceStatus;
    protected StatusInfo interfacesStatus;
    protected StatusInfo traitsStatus;
    private String sourceFolder = "";
    protected Text sourceText;
    protected Text newFileText;
    protected Text existingFileText;
    protected Text elementName;
    protected Text namespaceText;
    protected Composite modifiers;
    protected ListDialogField<IType> fSuperInterfacesDialogField;
    private ListDialogField<IType> fTraitsDialogField;
    private Button existingFileBtn;
    private Button firstBlockBtn;
    private Button browseSourceBtn;
    private Button browseExistingFile;
    private Composite checkBoxesCreationComp;
    protected int fTypeKind;
    private boolean isInExistingPHPFile = false;
    private Composite injectLocation;
    private String existingFileName = "";
    protected IType openByInterface = null;
    protected IType openByTrait = null;
    private Button addInterfacesBtn;
    private Button addTraitsBtn;
    private String initialElementName;
    private IPreferenceStore preferenceStore;
    private int removedSegmentNumber;
    private IFile existingFile;
    private Button namespaceCheckbox;

    public NewPHPTypePage(String pageName) {
        super(pageName);
        this.updateStatus(new StatusInfo());
        this.sourceFolderStatus = new StatusInfo();
        this.newFileStatus = new StatusInfo();
        this.existingFileStatus = new StatusInfo();
        this.elementNameStatus = new StatusInfo();
        this.namespaceStatus = new StatusInfo();
    }

    protected String getSuperInterfacesLabel() {
        if (this.fTypeKind != 2) {
            return Messages.NewPHPTypePage_interfaces;
        }
        return Messages.NewPHPTypePage_extendedInterfaces;
    }

    protected void createLocationSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.NewPHPTypePage_sourceFolder);
        this.sourceText = new Text(container, 2052);
        this.sourceText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.sourceText.setEditable(false);
        this.handlePHPVersion();
        this.sourceText.setText(this.sourceFolder);
        this.handlePHPVersion();
        this.sourceText.addModifyListener(e -> {
            Text textSource = (Text)e.getSource();
            this.sourceFolder = textSource.getText();
            this.handlePHPVersion();
            this.validatePageValues(1);
            this.validatePageValues(2);
            this.updateDisabled();
        });
        this.browseSourceBtn = new Button(container, 8);
        this.browseSourceBtn.setText(Messages.NewPHPTypePage_browse);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(this.browseSourceBtn);
        this.browseSourceBtn.setLayoutData((Object)gd);
        this.browseSourceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPTypePage.this.chooseNewSourceFolder();
                String sourcePath = NewPHPTypePage.this.sourceText.getText();
                if (sourcePath.length() > 0) {
                    NewPHPTypePage.this.handlePHPVersion();
                }
                NewPHPTypePage.this.validatePageValues(1);
                NewPHPTypePage.this.setDefaultNamespace();
            }
        });
        Button newFileBtn = new Button(container, 16);
        newFileBtn.setText(Messages.NewPHPTypePage_createNewFile);
        newFileBtn.setSelection(!this.isInExistingPHPFile);
        newFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewPHPTypePage.this.isInExistingPHPFile) {
                    NewPHPTypePage.this.isInExistingPHPFile = false;
                    if ("newfile.php".equals(NewPHPTypePage.this.newFileText.getText()) || NewPHPTypePage.this.newFileText.getText().trim().length() == 0) {
                        NewPHPTypePage.this.updateNewFilename();
                    }
                    NewPHPTypePage.this.updateDisabled();
                    NewPHPTypePage.this.setDefaultNamespace();
                    NewPHPTypePage.this.validatePageValues(2);
                    NewPHPTypePage.this.validatePageValues(3);
                }
            }
        });
        this.newFileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.newFileText.setLayoutData((Object)gd);
        this.newFileText.addModifyListener(e -> this.validatePageValues(2));
        new Label(container, 0);
        this.existingFileBtn = new Button(container, 16);
        this.existingFileBtn.setText(Messages.NewPHPTypePage_addInExistingFile);
        this.existingFileBtn.setSelection(this.isInExistingPHPFile);
        this.existingFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!NewPHPTypePage.this.isInExistingPHPFile) {
                    NewPHPTypePage.this.isInExistingPHPFile = true;
                    if (NewPHPTypePage.this.existingFile != null) {
                        NewPHPTypePage.this.sourceFolder = NewPHPTypePage.this.existingFile.getParent().getFullPath().toOSString();
                        NewPHPTypePage.this.sourceText.setText(NewPHPTypePage.this.sourceFolder);
                    }
                    NewPHPTypePage.this.updateDisabled();
                    NewPHPTypePage.this.setDefaultNamespace();
                    NewPHPTypePage.this.validatePageValues(2);
                    NewPHPTypePage.this.validatePageValues(3);
                    NewPHPTypePage.this.validatePageValues(1);
                }
            }
        });
        this.existingFileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.existingFileText.setLayoutData((Object)gd);
        this.existingFileText.setText(this.existingFileName);
        this.existingFileText.addModifyListener(e -> {
            this.validatePageValues(3);
            this.updateDisabled();
            this.setDefaultNamespace();
        });
        gd = new GridData(768);
        this.browseExistingFile = new Button(container, 8);
        this.browseExistingFile.setText(Messages.NewPHPTypePage_browse);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(this.browseExistingFile);
        this.browseExistingFile.setLayoutData((Object)gd);
        this.browseExistingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPTypePage.this.openPHPFileDialog();
                NewPHPTypePage.this.validatePageValues(3);
                NewPHPTypePage.this.validatePageValues(1);
                NewPHPTypePage.this.updateDisabled();
                NewPHPTypePage.this.setDefaultNamespace();
            }
        });
        new Label(container, 0);
        this.injectLocation = new Composite(container, 0);
        GridLayout injectLayout = new GridLayout(2, true);
        this.injectLocation.setLayout((Layout)injectLayout);
        injectLayout.marginHeight = 0;
        injectLayout.marginWidth = 0;
        this.firstBlockBtn = new Button(this.injectLocation, 16);
        this.firstBlockBtn.setText(Messages.NewPHPTypePage_firstPHPBlock);
        this.firstBlockBtn.setSelection(true);
        Button newPHPBlockBtn = new Button(this.injectLocation, 16);
        newPHPBlockBtn.setText(Messages.NewPHPTypePage_newPHPBlock);
        new Label(container, 258).setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
    }

    protected void handlePHPVersion() {
        String sourcePath = this.sourceText.getText();
        if (sourcePath.length() > 0) {
            IProject currentProject;
            this.phpVersion = this.isValidSourcePath(sourcePath) ? ((currentProject = this.getCurrentProject()) != null && !currentProject.isAccessible() ? null : ProjectOptions.getPHPVersion((IProject)currentProject)) : null;
        }
        if (this.phpVersion == null) {
            this.phpVersion = ProjectOptions.getDefaultPHPVersion();
        }
    }

    protected IScriptProject getProject() {
        IProject currProject;
        String sourcePath = this.sourceText.getText();
        if (sourcePath.length() > 0 && this.isValidSourcePath(sourcePath) && (currProject = this.getCurrentProject()) != null) {
            return DLTKCore.create((IProject)currProject);
        }
        return null;
    }

    protected String getProjectName(String sourcePath) {
        Path path = new Path(sourcePath);
        if (path.segmentCount() > 1) {
            sourcePath = path.segment(0);
        }
        return sourcePath;
    }

    protected boolean isValidSourcePath(String path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path containerPath = new Path(path.replace('\\', '/'));
        IResource resource = workspaceRoot.findMember((IPath)(containerPath = new Path(containerPath.segment(0))));
        return resource != null;
    }

    protected void addElementNameText(Composite container, String type) {
        GridData gd = new GridData();
        Label elementNameLabel = new Label(container, 0);
        elementNameLabel.setText(String.valueOf(type) + Messages.NewPHPTypePage_name);
        elementNameLabel.setLayoutData((Object)gd);
        this.elementName = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.elementName.setLayoutData((Object)gd);
        this.elementName.setFocus();
        this.elementName.addModifyListener(e -> {
            this.validatePageValues(4);
            this.updateNewFilename();
        });
        if (this.initialElementName != null) {
            this.elementName.setText(this.initialElementName);
        }
    }

    protected void addNamespaceText(Composite container) {
        GridData gd = new GridData();
        new Label(container, 0);
        this.namespaceCheckbox = new Button(container, 32);
        this.namespaceCheckbox.setText(BIND_NAMESPACE_AND_LOCATION);
        this.namespaceCheckbox.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.namespaceCheckbox.setLayoutData((Object)gd);
        this.namespaceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPTypePage.this.changeSourceFolder();
            }
        });
        Label elementNameLabel = new Label(container, 0);
        elementNameLabel.setText(Messages.NewPHPTypePage_0);
        elementNameLabel.setLayoutData((Object)new GridData());
        this.namespaceText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.namespaceText.setLayoutData((Object)gd);
        this.namespaceText.addModifyListener(e -> this.changeSourceFolder());
        this.setDefaultNamespace();
    }

    private void changeSourceFolder() {
        this.sourceText.setEditable(!this.namespaceCheckbox.getSelection());
        if (!this.existingFileBtn.getSelection() && this.namespaceCheckbox.getSelection()) {
            String[] segments;
            String sourceFolder = this.getSourceText();
            Path sourcePath = new Path(sourceFolder);
            sourcePath = sourcePath.removeLastSegments(sourcePath.segmentCount() - this.removedSegmentNumber);
            String[] stringArray = segments = this.namespaceText.getText().split("\\\\");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                sourcePath = sourcePath.append(segment);
                ++n2;
            }
            this.sourceText.setText(sourcePath.toOSString());
        }
        this.validatePageValues(5);
    }

    protected void setDefaultNamespace() {
        Path sourcePath;
        if (this.namespaceText == null) {
            return;
        }
        IFile existingFile = this.getExisitngFile();
        String sourceFolder = this.getSourceText();
        if (!sourceFolder.isEmpty()) {
            sourcePath = new Path(sourceFolder);
            this.removedSegmentNumber = this.firstSegmentsToRemoveForNamespace((IPath)sourcePath);
        }
        if (this.existingFileBtn.getSelection()) {
            String defaultNamespace;
            if (existingFile != null && (defaultNamespace = this.getLastNamespace()) != null) {
                this.namespaceText.setText(defaultNamespace);
            }
        } else if (!sourceFolder.isEmpty()) {
            sourcePath = new Path(sourceFolder);
            if ((sourcePath = sourcePath.removeFirstSegments(this.removedSegmentNumber)).segmentCount() > 0) {
                String defaultNamespace = sourcePath.toString().replace("/", "\\");
                if (defaultNamespace.endsWith("\\")) {
                    defaultNamespace = defaultNamespace.substring(0, defaultNamespace.length() - 1);
                }
                this.namespaceText.setText(defaultNamespace);
            } else {
                this.namespaceText.setText("");
            }
        }
    }

    private int firstSegmentsToRemoveForNamespace(IPath sourcePath) {
        IScriptProject project;
        block5: {
            project = this.getProject();
            if (project.exists() && PHPToolkitUtil.isFromPHPProject((IModelElement)project)) break block5;
            return 1;
        }
        try {
            IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
            int n = iProjectFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                int matching = projectFragment.getPath().matchingFirstSegments(sourcePath);
                if (matching > 1) {
                    return matching;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
        return 1;
    }

    protected void addElementModifiers(Composite container, String[] modifiersNames) {
        Label modifiersLabel = new Label(container, 0);
        modifiersLabel.setText(Messages.NewPHPTypePage_modifiers);
        this.modifiers = new Composite(container, 0);
        int len = modifiersNames.length;
        GridLayout layout = new GridLayout();
        this.modifiers.setLayout((Layout)layout);
        layout.numColumns = len;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        int i = 0;
        while (i < modifiersNames.length) {
            Button check = new Button(this.modifiers, 16);
            check.setText(modifiersNames[i]);
            if (i == 0) {
                check.setSelection(true);
            }
            ++i;
        }
        new Label(container, 0);
    }

    protected void createSuperInterfacesControls(Composite parent) {
        String INTERFACE = "interface";
        Control[] controls = this.fSuperInterfacesDialogField.doFillIntoGrid(parent, 3);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        controls[1].setLayoutData((Object)gd);
        final TableViewer tableViewer = this.fSuperInterfacesDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fTypeKind == 1 ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.getMaxFieldWidth();
        this.addInterfacesBtn = (Button)this.fSuperInterfacesDialogField.getButtonBox(parent).getChildren()[0];
        this.addInterfacesBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result = NewPHPTypePage.this.chooseInterfaces();
                if (result != null && result instanceof IType) {
                    NewPHPTypePage.this.fSuperInterfacesDialogField.addElement((IType)result);
                }
                NewPHPTypePage.this.fSuperInterfacesDialogField.refresh();
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }
        });
    }

    protected void createTraitsControls(Composite parent) {
        String INTERFACE = "trait";
        Control[] controls = this.fTraitsDialogField.doFillIntoGrid(parent, 3);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        controls[1].setLayoutData((Object)gd);
        final TableViewer tableViewer = this.fTraitsDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"trait"});
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        gd = (GridData)this.fTraitsDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fTypeKind == 1 ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.getMaxFieldWidth();
        this.addTraitsBtn = (Button)this.fTraitsDialogField.getButtonBox(parent).getChildren()[0];
        this.addTraitsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result = NewPHPTypePage.this.chooseTraits();
                if (result != null && result instanceof IType) {
                    NewPHPTypePage.this.fTraitsDialogField.addElement((IType)result);
                }
                NewPHPTypePage.this.fTraitsDialogField.refresh();
                NewPHPTypePage.this.validateTraits(NewPHPTypePage.this.getProject());
            }
        });
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public String getNewFileName() {
        return this.newFileText.getText();
    }

    public String getNamespace() {
        String lastNamespace;
        if (this.namespaceText == null) {
            return "";
        }
        if (this.isInFirstPHPBlock() && (lastNamespace = this.getLastNamespace()) != null) {
            if (!lastNamespace.equals(this.namespaceText.getText())) {
                return this.namespaceText.getText();
            }
            return "";
        }
        return this.namespaceText.getText();
    }

    public String getRealNamespace() {
        if (this.namespaceText == null) {
            return "";
        }
        return this.namespaceText.getText();
    }

    public String getExistingFileName() {
        return this.existingFileText.getText();
    }

    public IFile getExisitngFile() {
        String sourceText = this.getSourceText();
        String existingFileName = this.getExistingFileName();
        if (existingFileName == null || existingFileName.isEmpty()) {
            return null;
        }
        Path p = new Path(String.valueOf(sourceText) + File.separatorChar + existingFileName);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        return wsRoot.getFile((IPath)p);
    }

    public boolean isInExistingPHPFile() {
        return this.existingFileBtn.getSelection();
    }

    public boolean isInFirstPHPBlock() {
        return this.firstBlockBtn.getSelection();
    }

    public String getElementName() {
        return this.elementName.getText();
    }

    public void setElementName(String elementName) {
        this.initialElementName = elementName;
    }

    public Map<String, Boolean> getModifiers() {
        if (this.modifiers == null) {
            return null;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Button[] modBtns = (Button[])this.modifiers.getChildren();
        if (modBtns == null || modBtns.length == 0) {
            return null;
        }
        Button[] buttonArray = modBtns;
        int n = modBtns.length;
        int n2 = 0;
        while (n2 < n) {
            Button element = buttonArray[n2];
            result.put(element.getText(), element.getSelection());
            ++n2;
        }
        return result;
    }

    public List<IType> getInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public List<IType> getTraits() {
        return this.fTraitsDialogField.getElements();
    }

    protected Composite addCheckBoxesInElementSection(Composite elementSection, String[] checkBoxes) {
        new Label(elementSection, 0);
        Composite checkBoxesContainer = new Composite(elementSection, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        checkBoxesContainer.setLayout((Layout)layout);
        String[] stringArray = checkBoxes;
        int n = checkBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Button button = new Button(checkBoxesContainer, 32);
            button.setText(element);
            ++n2;
        }
        return checkBoxesContainer;
    }

    protected void addCheckboxesCreation(Composite elementSection, String[] checkBoxes) {
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        Label whichMethods = new Label(elementSection, 0);
        whichMethods.setText(Messages.NewPHPTypePage_checkboxesToCreate);
        whichMethods.setLayoutData((Object)gd);
        this.checkBoxesCreationComp = new Composite(elementSection, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 3;
        layout.marginWidth = 0;
        this.checkBoxesCreationComp.setLayout((Layout)layout);
        String[] stringArray = checkBoxes;
        int n = checkBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null) {
                Button button = new Button(this.checkBoxesCreationComp, 32);
                button.setText(element);
            } else {
                new Label(this.checkBoxesCreationComp, 0);
            }
            ++n2;
        }
    }

    public boolean isCheckboxCreationChecked(String name) {
        Control[] btns;
        Control[] controlArray = btns = this.checkBoxesCreationComp.getChildren();
        int n = btns.length;
        int n2 = 0;
        while (n2 < n) {
            Button button;
            Control control = controlArray[n2];
            if (control instanceof Button && (button = (Button)control).getText().equals(name)) {
                return button.getSelection();
            }
            ++n2;
        }
        return false;
    }

    protected void initContainerPage(IModelElement elem) {
        IContainer initRoot = null;
        if (elem != null) {
            IResource resource = elem.getResource();
            if (resource != null) {
                initRoot = resource.getParent();
            } else {
                IScriptProject sp = (IScriptProject)elem.getAncestor(2);
                if (sp != null) {
                    initRoot = sp.getProject();
                }
            }
        }
        this.setContainer(initRoot);
    }

    public void setContainer(IContainer root) {
        String str;
        this.sourceFolder = str = root == null ? "" : root.getFullPath().toOSString();
    }

    public Object init(IStructuredSelection selection) {
        IModelElement result;
        IModelElement element = this.getInitialPHPElement(selection);
        if (element != null) {
            this.initContainerPage(element);
            result = element;
        } else {
            IContainer container = this.getInitialContainer(selection);
            if (container != null) {
                this.setContainer(container);
                result = container;
            } else {
                result = null;
            }
        }
        return result;
    }

    protected void initValues() {
        this.validatePageValues(1);
        if (!this.isInExistingPHPFile) {
            Control[] buttons;
            this.existingFileText.setEnabled(false);
            this.browseExistingFile.setEnabled(false);
            Control[] controlArray = buttons = this.injectLocation.getChildren();
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.setEnabled(false);
                ++n2;
            }
            if (this.namespaceText != null) {
                this.namespaceText.setEnabled(true);
            }
        } else {
            this.newFileText.setEnabled(false);
            this.sourceText.setEnabled(false);
            this.browseSourceBtn.setEnabled(false);
            if (this.namespaceText != null) {
                this.namespaceText.setEnabled(this.isNamespaceEnabled());
            }
        }
        if (!this.isInExistingPHPFile) {
            this.validatePageValues(2);
        }
        this.validatePageValues(4);
        if (this.openByInterface != null) {
            this.fSuperInterfacesDialogField.addElement(this.openByInterface);
        }
        if (this.openByTrait != null) {
            this.fTraitsDialogField.addElement(this.openByTrait);
        }
        this.initGeneratedGroupValues();
        this.changeButtonEnableStatus();
    }

    protected void initGeneratedGroupValues() {
        Button[] checkboxes;
        this.preferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        Button[] buttonArray = checkboxes = this.getGeneratedGroupCheckboxes();
        int n = checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            this.initSelectionStatus(button);
            ++n2;
        }
        this.initSelectionStatus(this.namespaceCheckbox);
    }

    private void initSelectionStatus(Button button) {
        if (button == null) {
            return;
        }
        String lastCheckboxValue = this.preferenceStore.getString(String.valueOf(this.getPreferencePrefix()) + button.getText());
        if (lastCheckboxValue != null && lastCheckboxValue.trim().length() > 0) {
            button.setSelection(lastCheckboxValue.equals("1"));
        } else if (button.getText().equals(INHERITED_ABSTRACT_METHODS) || button.getText().equals(BIND_NAMESPACE_AND_LOCATION)) {
            this.preferenceStore.setValue(String.valueOf(this.getPreferencePrefix()) + button.getText(), "1");
            button.setSelection(true);
        }
    }

    public void saveGeneratedGroupValues() {
        Button[] checkboxes;
        Button[] buttonArray = checkboxes = this.getGeneratedGroupCheckboxes();
        int n = checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            this.preferenceStore.setValue(String.valueOf(this.getPreferencePrefix()) + button.getText(), button.getSelection() ? "1" : "0");
            ++n2;
        }
        if (this.namespaceCheckbox != null) {
            this.preferenceStore.setValue(String.valueOf(this.getPreferencePrefix()) + this.namespaceCheckbox.getText(), this.namespaceCheckbox.getSelection() ? "1" : "0");
        }
    }

    protected Button[] getGeneratedGroupCheckboxes() {
        ArrayList<Button> list = new ArrayList<Button>();
        Control[] btns = null;
        if (this.checkBoxesCreationComp != null) {
            Control[] controlArray = btns = this.checkBoxesCreationComp.getChildren();
            int n = btns.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Button) {
                    list.add((Button)control);
                }
                ++n2;
            }
        }
        return list.toArray(new Button[list.size()]);
    }

    protected String getPreferencePrefix() {
        return "";
    }

    protected void updateDisabled() {
        if (!this.isInExistingPHPFile) {
            Control[] buttons;
            this.existingFileText.setEnabled(false);
            this.browseExistingFile.setEnabled(false);
            Control[] controlArray = buttons = this.injectLocation.getChildren();
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.setEnabled(false);
                ++n2;
            }
            this.newFileText.setEnabled(true);
            this.sourceText.setEnabled(true);
            this.browseSourceBtn.setEnabled(true);
            if (this.namespaceText != null) {
                this.namespaceText.setEnabled(true);
            }
        } else {
            Control[] buttons;
            this.newFileText.setEnabled(false);
            this.sourceText.setEnabled(false);
            this.browseSourceBtn.setEnabled(false);
            this.existingFileText.setEnabled(true);
            this.browseExistingFile.setEnabled(true);
            Control[] controlArray = buttons = this.injectLocation.getChildren();
            int n = buttons.length;
            int n3 = 0;
            while (n3 < n) {
                Control element = controlArray[n3];
                element.setEnabled(true);
                ++n3;
            }
            if (this.namespaceText != null) {
                this.namespaceText.setEnabled(this.isNamespaceEnabled());
            }
        }
    }

    protected boolean isNamespaceEnabled() {
        ISourceModule existingPHPFile = DLTKCore.createSourceModuleFrom((IFile)this.getExisitngFile());
        if (existingPHPFile != null && existingPHPFile.exists()) {
            try {
                IType firstElement;
                IModelElement[] rootElements = existingPHPFile.getChildren();
                if (rootElements.length > 0 && rootElements[0] instanceof IType && PHPFlags.isNamespace((int)(firstElement = (IType)rootElements[0]).getFlags())) {
                    return true;
                }
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
        return false;
    }

    protected String getLastNamespace() {
        ISourceModule existingPHPFile = DLTKCore.createSourceModuleFrom((IFile)this.getExisitngFile());
        if (existingPHPFile != null && existingPHPFile.exists()) {
            try {
                IModelElement[] rootElements = existingPHPFile.getChildren();
                int i = rootElements.length - 1;
                while (i >= 0) {
                    IType firstElement;
                    if (rootElements[i] instanceof IType && PHPFlags.isNamespace((int)(firstElement = (IType)rootElements[i]).getFlags())) {
                        return firstElement.getFullyQualifiedName();
                    }
                    --i;
                }
                return "";
            }
            catch (ModelException e) {
                return null;
            }
        }
        return null;
    }

    protected void validatePageValues(int validationCode) {
        IProject currentProject;
        switch (validationCode) {
            case 4: {
                String message;
                this.elementNameStatus = new StatusInfo();
                if (this.getElementName() == null || this.getElementName().length() == 0) {
                    message = Messages.NewPHPTypePage_nameMustNotBeEmpty;
                    switch (this.fTypeKind) {
                        case 1: {
                            message = String.valueOf(Messages.NewPHPTypePage_class) + message;
                            break;
                        }
                        case 2: {
                            message = String.valueOf(Messages.NewPHPTypePage_interface) + message;
                            break;
                        }
                        case 3: {
                            message = String.valueOf(Messages.NewPHPTypePage_trait) + message;
                        }
                    }
                    this.elementNameStatus.setError(message);
                } else if (this.isInExistingPHPFile()) {
                    Path p = new Path(String.valueOf(this.getSourceText()) + File.separatorChar + this.getExistingFileName());
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = wsRoot.getFile((IPath)p);
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                    if (sourceModule != null && sourceModule.exists()) {
                        IType[] types = null;
                        try {
                            types = sourceModule.getTypes();
                        }
                        catch (ModelException e) {
                            Logger.logException(e);
                        }
                        if (types != null) {
                            IType[] iTypeArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType type = iTypeArray[n2];
                                if (type.getElementName().equalsIgnoreCase(this.getElementName())) {
                                    if (this.fTypeKind == 1 && !PHPFlags.isClass((int)type.getElementType())) {
                                        this.elementNameStatus.setError(String.valueOf(Messages.NewPHPTypePage_class) + this.getElementName() + Messages.NewPHPTypePage_alreadyExistsInFile + this.existingFileName);
                                        break;
                                    }
                                    if (this.fTypeKind == 2 && PHPFlags.isInterface((int)type.getElementType())) {
                                        this.elementNameStatus.setError(String.valueOf(Messages.NewPHPTypePage_interface) + this.getElementName() + Messages.NewPHPTypePage_alreadyExistsInFile);
                                        break;
                                    }
                                    if (this.fTypeKind == 3 && PHPFlags.isInterface((int)type.getElementType())) {
                                        this.elementNameStatus.setError(String.valueOf(Messages.NewPHPTypePage_trait) + this.getElementName() + Messages.NewPHPTypePage_alreadyExistsInFile);
                                        break;
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                }
                if (this.getProject() != null && !this.isValidPHPIdentifier(this.getElementName())) {
                    message = Messages.NewPHPTypePage_InvalidPhp;
                    String nameLabel = Messages.NewPHPTypePage_InvalidPhpName;
                    switch (this.fTypeKind) {
                        case 1: {
                            message = String.valueOf(message) + Messages.NewPHPTypePage_class + nameLabel;
                            break;
                        }
                        case 2: {
                            message = String.valueOf(message) + Messages.NewPHPTypePage_interface + nameLabel;
                            break;
                        }
                        case 3: {
                            message = String.valueOf(message) + Messages.NewPHPTypePage_trait + nameLabel;
                        }
                    }
                    this.elementNameStatus.setError(message);
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                this.sourceFolderChanged();
                break;
            }
            case 3: {
                this.existingFileStatus = new StatusInfo();
                if (this.isInExistingPHPFile()) {
                    if (this.existingFileText.getText().length() == 0) {
                        this.existingFileStatus.setError(Messages.NewPHPTypePage_existingFileMustNotBeEmpty);
                    } else if (!this.isPathExist(String.valueOf(this.sourceText.getText()) + File.separatorChar + this.existingFileText.getText())) {
                        this.existingFileStatus.setError(String.valueOf(Messages.NewPHPTypePage_targetPHPFile) + this.existingFileText.getText() + Messages.NewPHPTypePage_doesNotExist);
                    } else if (!this.isPHPSuffix(this.existingFileText.getText())) {
                        this.existingFileStatus.setError(String.valueOf(Messages.NewPHPTypePage_phpFile) + this.existingFileText.getText() + Messages.NewPHPTypePage_notPhpExtention);
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 2: {
                this.newFileStatus = new StatusInfo();
                if (!this.isInExistingPHPFile()) {
                    String fileName = this.newFileText.getText();
                    if (fileName.length() == 0) {
                        this.newFileStatus.setError(Messages.NewPHPTypePage_fileMustnotBeEmpty);
                    } else if (this.isPathExist(String.valueOf(this.sourceText.getText()) + File.separatorChar + fileName)) {
                        this.newFileStatus.setError(String.valueOf(Messages.NewPHPTypePage_phpFile) + fileName + Messages.NewPHPTypePage_alreadyExists);
                    } else if (!this.isPHPSuffix(fileName)) {
                        this.newFileStatus.setError(String.valueOf(Messages.NewPHPTypePage_phpFile) + fileName + Messages.NewPHPTypePage_notPhpExtention);
                    } else if (!this.isValidFileName(fileName)) {
                        this.newFileStatus.setError(String.valueOf(Messages.NewPHPTypePage_phpFile) + MessageFormat.format(Messages.NewPHPTypePage_filename_not_valid, fileName));
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 5: {
                this.namespaceStatus = new StatusInfo();
                String namespace = this.getNamespace();
                if (namespace != null && !namespace.isEmpty()) {
                    int separator = namespace.indexOf(47, 0);
                    if (separator != -1) {
                        this.namespaceStatus.setError(Messages.NewPHPTypePage_invalidSeparator);
                    } else if (namespace.endsWith("\\")) {
                        this.namespaceStatus.setError(Messages.NewPHPTypePage_emptySublevel);
                    } else {
                        String[] segments = namespace.split("\\\\");
                        if (segments.length == 1 && !this.isValidPHPIdentifier(namespace.trim())) {
                            this.namespaceStatus.setError(Messages.NewPHPTypePage_invalidNamespaceName);
                        } else {
                            String[] stringArray = segments;
                            int n = segments.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String segment = stringArray[n3];
                                if (segment.isEmpty()) {
                                    this.namespaceStatus.setError(Messages.NewPHPTypePage_emptySublevel);
                                } else {
                                    try {
                                        Integer.parseInt(segment);
                                        this.namespaceStatus.setError(Messages.NewPHPTypePage_invalidSublevel);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                ++n3;
                            }
                        }
                    }
                }
                this.updateStatus(this.findMostSevereStatus());
            }
        }
        String sourcePathStr = this.getProjectName(this.getSourceText());
        if (sourcePathStr == null || sourcePathStr.length() == 0) {
            return;
        }
        Path projPath = new Path(sourcePathStr);
        if (projPath.segmentCount() == 1 && (currentProject = this.getCurrentProject()) != null && currentProject.exists()) {
            IScriptProject model = DLTKCore.create((IProject)currentProject);
            if (this.getInterfaces().size() > 0) {
                this.validateInterfaces(model);
            }
            if (this.getTraits().size() > 0) {
                this.validateTraits(model);
            }
        }
    }

    private boolean isValidFileName(String fileName) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(fileName), 1);
        if (!status.isOK()) {
            return false;
        }
        String trimedString = fileName.trim();
        char[] scannedID = trimedString.toCharArray();
        if (CharOperation.contains((char)'$', (char[])scannedID)) {
            return false;
        }
        return !CharOperation.startsWith((char[])scannedID, (char[])new char[]{'.'});
    }

    protected void validateInterfaces(IScriptProject model) {
        this.interfacesStatus = new StatusInfo();
        Iterator<IType> iter = this.getInterfaces().iterator();
        while (iter.hasNext()) {
            this.interfacesStatus = new StatusInfo();
            IType interfaceObj = iter.next();
            String interfaceName = interfaceObj.getElementName();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getProject());
            IType[] classes = PHPModelAccess.getDefault().findTypes(interfaceName, ISearchEngine.MatchRule.EXACT, 8, 0, scope, (IProgressMonitor)new NullProgressMonitor());
            if (classes == null || classes.length == 0) {
                this.interfacesStatus.setError(String.valueOf(Messages.NewPHPTypePage_interface) + interfaceName + Messages.NewPHPTypePage_doesnotExistInProject);
                this.updateStatus(this.findMostSevereStatus());
                return;
            }
            boolean foundSiblings = false;
            IType[] iTypeArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                IType element = iTypeArray[n2];
                if (element.getPath().toOSString().equals(interfaceObj.getPath().toOSString())) {
                    interfaceObj = element;
                    foundSiblings = true;
                    break;
                }
                ++n2;
            }
            if (!foundSiblings) {
                this.interfacesStatus.setWarning(String.valueOf(Messages.NewPHPClassPage_interface) + interfaceName);
                this.updateStatus(this.findMostSevereStatus());
                return;
            }
            ISourceModule sourceModel = interfaceObj.getSourceModule();
            if (sourceModel == null) continue;
            IPath superClassSrcPath = sourceModel.getPath();
            String superClassSrcFileName = superClassSrcPath.toOSString();
            String currentSrcFileName = null;
            currentSrcFileName = this.isInExistingPHPFile() ? this.getExistingFileName() : this.getNewFileName();
            if (superClassSrcPath.removeLastSegments(1).equals((Object)new Path(this.getSourceText())) || !superClassSrcFileName.equals(currentSrcFileName)) continue;
            this.interfacesStatus.setError(String.valueOf(Messages.NewPHPTypePage_cannotImplementInterface) + interfaceName);
            this.updateStatus(this.findMostSevereStatus());
            return;
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    protected void validateTraits(IScriptProject model) {
        this.traitsStatus = new StatusInfo();
        Iterator<IType> iter = this.getTraits().iterator();
        while (iter.hasNext()) {
            this.traitsStatus = new StatusInfo();
            IType interfaceObj = iter.next();
            String interfaceName = interfaceObj.getElementName();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getProject());
            IType[] classes = PHPModelAccess.getDefault().findTypes(interfaceName, ISearchEngine.MatchRule.EXACT, 8, 0, scope, (IProgressMonitor)new NullProgressMonitor());
            if (classes == null || classes.length == 0) {
                this.traitsStatus.setError(String.valueOf(Messages.NewPHPTypePage_trait) + interfaceName + Messages.NewPHPTypePage_doesnotExistInProject);
                this.updateStatus(this.findMostSevereStatus());
                return;
            }
            boolean foundSiblings = false;
            IType[] iTypeArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                IType element = iTypeArray[n2];
                if (element.getPath().toOSString().equals(interfaceObj.getPath().toOSString())) {
                    interfaceObj = element;
                    foundSiblings = true;
                    break;
                }
                ++n2;
            }
            if (!foundSiblings) {
                this.traitsStatus.setWarning(String.valueOf(Messages.NewPHPClassPage_trait) + interfaceName);
                this.updateStatus(this.findMostSevereStatus());
                return;
            }
            ISourceModule sourceModel = interfaceObj.getSourceModule();
            if (sourceModel == null) continue;
            IPath superClassSrcPath = sourceModel.getPath();
            String superClassSrcFileName = superClassSrcPath.toOSString();
            String currentSrcFileName = null;
            currentSrcFileName = this.isInExistingPHPFile() ? this.getExistingFileName() : this.getNewFileName();
            if (superClassSrcPath.removeLastSegments(1).equals((Object)new Path(this.getSourceText())) || !superClassSrcFileName.equals(currentSrcFileName)) continue;
            this.traitsStatus.setError(String.valueOf(Messages.NewPHPTypePage_cannotImplementTrait) + interfaceName);
            this.updateStatus(this.findMostSevereStatus());
            return;
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    private boolean isPHPSuffix(String filename) {
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        return type.isAssociatedWith(filename);
    }

    private boolean isValidPHPIdentifier(String name) {
        if (name != null && name.length() > 0) {
            if (!PHP_IDENTIFIER_PATTERN.matcher(name).matches()) {
                return false;
            }
            if (this.isKeyword(name)) {
                return false;
            }
        }
        return true;
    }

    private boolean isKeyword(String name) {
        Collection foundKeywords = PHPKeywords.getInstance((IProject)this.getProject().getProject()).findNamesByPrefix(name);
        for (String keyword : foundKeywords) {
            if (!name.equalsIgnoreCase(keyword)) continue;
            return true;
        }
        return false;
    }

    protected void sourceFolderChanged() {
        this.sourceFolderStatus = new StatusInfo();
        String sourcePath = this.sourceText.getText();
        if (sourcePath.length() == 0) {
            this.sourceFolderStatus.setError(Messages.NewPHPTypePage_sourceFolderMustNotBeEmpty);
        } else if (!this.isValidSourcePath(sourcePath)) {
            this.sourceFolderStatus.setError(String.valueOf(Messages.NewPHPTypePage_sourceFolder2) + sourcePath + Messages.NewPHPTypePage_isIllegal);
        } else {
            IProject currentProject = this.getCurrentProject();
            if (currentProject == null || !currentProject.isAccessible()) {
                this.sourceFolderStatus.setError(String.valueOf(Messages.NewPHPTypePage_sourceFolder2) + sourcePath + Messages.NewPHPTypePage_isNotAccessible);
            } else {
                IScriptProject model = DLTKCore.create((IProject)currentProject);
                if (model == null) {
                    this.sourceFolderStatus.setError(String.valueOf(Messages.NewPHPTypePage_sourceFolder) + sourcePath + Messages.NewPHPTypePage_doesNotPointToPhpProject);
                }
            }
        }
        this.updateStatus(this.findMostSevereStatus());
        if (this.addInterfacesBtn != null) {
            if (this.sourceFolderStatus.getCode() != 0) {
                this.addInterfacesBtn.setEnabled(false);
            } else {
                this.addInterfacesBtn.setEnabled(true);
            }
        }
        if (this.addTraitsBtn != null) {
            if (this.sourceFolderStatus.getCode() != 0) {
                this.addTraitsBtn.setEnabled(false);
            } else {
                this.addTraitsBtn.setEnabled(true);
            }
        }
    }

    protected boolean isPathExist(String path) {
        Path containerPath;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember((IPath)(containerPath = new Path(path)));
        return resource != null;
    }

    protected IModelElement getInitialPHPElement(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            ISourceModule codeData = null;
            if (obj instanceof NodeImpl) {
                obj = ((IAdaptable)obj).getAdapter(IModelElement.class);
            }
            if (obj instanceof ISourceModule) {
                codeData = (ISourceModule)obj;
                while (!(codeData == null || codeData instanceof ISourceModule || codeData instanceof IType || codeData instanceof IMethod)) {
                    codeData = codeData.getParent();
                }
                if (codeData instanceof ISourceModule) {
                    try {
                        if (codeData.getCorrespondingResource() == null) {
                            this.isInExistingPHPFile = false;
                            return codeData;
                        }
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                    this.isInExistingPHPFile = true;
                    String filename = null;
                    try {
                        filename = codeData.getCorrespondingResource().getFullPath().toOSString();
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                        return null;
                    }
                    int idx = Math.max(filename.lastIndexOf(92), filename.lastIndexOf(47));
                    if (idx != -1) {
                        this.existingFileName = filename.substring(idx + 1);
                    }
                    try {
                        this.existingFile = (IFile)codeData.getCorrespondingResource();
                    }
                    catch (ModelException modelException) {}
                } else if (codeData instanceof IType) {
                    this.isInExistingPHPFile = false;
                    IType pClassData = (IType)codeData;
                    if (Flags.isInterface((int)pClassData.getElementType())) {
                        this.openByInterface = pClassData;
                    } else if (PHPFlags.isTrait((int)pClassData.getElementType())) {
                        this.openByTrait = pClassData;
                    }
                } else {
                    this.isInExistingPHPFile = false;
                }
                return codeData;
            }
            if (obj instanceof IFile) {
                this.isInExistingPHPFile = true;
                this.existingFileName = ((IFile)obj).getName();
                this.existingFile = (IFile)obj;
                codeData = DLTKCore.create((IFile)((IFile)obj));
            }
            if (codeData != null) {
                return codeData;
            }
        }
        return null;
    }

    protected IContainer getInitialContainer(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IModelElement) {
                IScriptProject sp;
                IResource resource = ((IModelElement)obj).getResource();
                if (resource != null && !(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                if (resource == null && (sp = (IScriptProject)((IModelElement)obj).getAncestor(2)) != null) {
                    resource = sp.getProject();
                }
                return (IContainer)resource;
            }
            if (obj instanceof IResource) {
                IResource resource = (IResource)obj;
                if (resource != null && !(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                return (IContainer)resource;
            }
        }
        return null;
    }

    public void createControl(Composite parent) {
        String[] stringArray = new String[3];
        stringArray[0] = Messages.NewPHPTypePage_add;
        stringArray[2] = Messages.NewPHPTypePage_remove;
        String[] addButtons = stringArray;
        IListAdapter<IType> listAdapter = new IListAdapter<IType>(){

            @Override
            public void customButtonPressed(ListDialogField<IType> field, int index) {
            }

            @Override
            public void doubleClicked(ListDialogField<IType> field) {
            }

            @Override
            public void selectionChanged(ListDialogField<IType> field) {
            }
        };
        this.fSuperInterfacesDialogField = new ListDialogField<IType>((IListAdapter)listAdapter, addButtons, (ILabelProvider)new PHPFullPathLabelProvider()){

            @Override
            public void removeElement(IType element) throws IllegalArgumentException {
                super.removeElement(element);
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }

            @Override
            public void removeElements(List<IType> elements) {
                super.removeElements(elements);
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }

            @Override
            public void removeAllElements() {
                super.removeAllElements();
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }
        };
        this.fSuperInterfacesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fSuperInterfacesDialogField.setLabelText(this.getSuperInterfacesLabel());
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        this.fSuperInterfacesDialogField.setDialogFieldListener(this);
        this.fTraitsDialogField = new ListDialogField<IType>((IListAdapter)listAdapter, addButtons, (ILabelProvider)new PHPFullPathLabelProvider()){

            @Override
            public void removeElement(IType element) throws IllegalArgumentException {
                super.removeElement(element);
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }

            @Override
            public void removeElements(List<IType> elements) {
                super.removeElements(elements);
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }

            @Override
            public void removeAllElements() {
                super.removeAllElements();
                NewPHPTypePage.this.validateInterfaces(NewPHPTypePage.this.getProject());
            }
        };
        this.fTraitsDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fTraitsDialogField.setLabelText(Messages.NewPHPClassPage_traits);
        this.fTraitsDialogField.setRemoveButtonIndex(2);
        this.fTraitsDialogField.setDialogFieldListener(this);
    }

    private void chooseNewSourceFolder() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.NewPHPTypePage_selectNewSourceFolder);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.sourceText.setText(((Path)result[0]).toOSString());
        }
    }

    private void openPHPFileDialog() {
        IFile[] selected = this.choosePHPEntries(null, new ArrayList<Object>());
        if (selected == null || selected.length == 0) {
            return;
        }
        this.existingFile = selected[0];
        this.sourceText.setText(this.existingFile.getParent().getFullPath().toString());
        this.existingFileText.setText(this.existingFile.getName());
    }

    private IFile[] choosePHPEntries(IPath initialSelection, List<Object> usedFiles) {
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(Messages.NewPHPTypePage_phpFileSelection);
        dialog.setMessage(Messages.NewPHPTypePage_selectExistingPHPFile);
        dialog.addFilter((ViewerFilter)new NotUsedPHPFileFilter(usedFiles));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IFile[] res = new IFile[elements.length];
            int i = 0;
            while (i < res.length) {
                res[i] = (IFile)elements[i];
                ++i;
            }
            return res;
        }
        return null;
    }

    protected Object chooseInterfaces() {
        Object[] resultArray;
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createSearchScope((IModelElement)this.getProject()), 0, new TypeSelectionExtension(){

            public ITypeInfoFilterExtension getFilterExtension() {
                return typeInfoRequestor -> {
                    if (Flags.isInterface((int)typeInfoRequestor.getModifiers())) {
                        List<IType> alreadySelectedInterfaces = NewPHPTypePage.this.fSuperInterfacesDialogField.getElements();
                        for (IType interfaceName : alreadySelectedInterfaces) {
                            if (!interfaceName.getElementName().equalsIgnoreCase(typeInfoRequestor.getTypeName())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                };
            }
        }, PHPLanguageToolkit.getDefault());
        dialog.setListLabelProvider((ILabelProvider)new PHPFullPathLabelProvider());
        dialog.setListSelectionLabelDecorator((ILabelDecorator)new PHPFullPathLabelProvider());
        dialog.setDetailsLabelProvider((ILabelProvider)new StatusLineLabelProvider());
        dialog.setTitle(Messages.NewPHPTypePage_interfacesSelection);
        dialog.setMessage(Messages.NewPHPTypePage_selectInterfaces);
        dialog.setInitialPattern("", 2);
        if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
            return resultArray[0];
        }
        return null;
    }

    protected Object chooseTraits() {
        Object[] resultArray;
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createSearchScope((IModelElement)this.getProject()), 0, new TypeSelectionExtension(){

            public ITypeInfoFilterExtension getFilterExtension() {
                return typeInfoRequestor -> {
                    if (PHPFlags.isTrait((int)typeInfoRequestor.getModifiers())) {
                        List alreadySelectedInterfaces = NewPHPTypePage.this.fTraitsDialogField.getElements();
                        for (IType interfaceName : alreadySelectedInterfaces) {
                            if (!interfaceName.getElementName().equalsIgnoreCase(typeInfoRequestor.getTypeName())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                };
            }
        }, PHPLanguageToolkit.getDefault());
        dialog.setListLabelProvider((ILabelProvider)new PHPFullPathLabelProvider());
        dialog.setListSelectionLabelDecorator((ILabelDecorator)new PHPFullPathLabelProvider());
        dialog.setDetailsLabelProvider((ILabelProvider)new StatusLineLabelProvider());
        dialog.setTitle(Messages.NewPHPTypePage_traitsSelection);
        dialog.setMessage(Messages.NewPHPTypePage_selectTraits);
        dialog.setInitialPattern("", 2);
        if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
            return resultArray[0];
        }
        return null;
    }

    public String getSourceText() {
        return this.sourceText.getText().trim();
    }

    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.sourceFolderStatus, this.elementNameStatus, this.newFileStatus, this.existingFileStatus, this.interfacesStatus, this.namespaceStatus});
    }

    public PHPVersion getPHPVersion() {
        return this.phpVersion;
    }

    protected void updateNewFilename() {
        if (this.newFileText == null || this.newFileText.isDisposed()) {
            return;
        }
        if (!this.elementNameStatus.matches(4) && !this.isInExistingPHPFile()) {
            this.newFileText.setText(String.valueOf(this.getElementName()) + ".php");
        }
    }

    protected IProject getCurrentProject() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String projectPath = this.getSourceText();
        if (projectPath == null || projectPath.length() == 0) {
            return null;
        }
        if (!this.isValidSourcePath(projectPath)) {
            return null;
        }
        return workspaceRoot.getProject(this.getProjectName(projectPath));
    }

    protected String getValue(Key key) {
        IProject currProject = this.getCurrentProject();
        IScopeContext[] fLookupOrder = currProject != null ? new IScopeContext[]{new ProjectScope(currProject), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        WorkingCopyManager manager = new WorkingCopyManager();
        return key.getStoredValue(fLookupOrder, false, (IWorkingCopyManager)manager);
    }

    protected static final Key getPHPCoreKey(String key) {
        return NewPHPTypePage.getKey("org.eclipse.php.core", key);
    }

    protected static Key getKey(String plugin, String key) {
        return new Key(plugin, key);
    }

    public Button getButton(String name) {
        Button[] checkboxes;
        Button[] buttonArray = checkboxes = this.getGeneratedGroupCheckboxes();
        int n = checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            if (button.getText().trim().equals(name)) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.changeButtonEnableStatus();
    }

    protected void changeButtonEnableStatus() {
        Button button = this.getButton(REQUIRE_ONCE);
        if (button != null) {
            button.setEnabled(this.requireOnceShouldEnabled());
        }
    }

    protected boolean requireOnceShouldEnabled() {
        return !this.fSuperInterfacesDialogField.getElements().isEmpty() || !this.fTraitsDialogField.getElements().isEmpty();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.elementName.setFocus();
        }
    }

    class NotUsedPHPFileFilter
    extends ViewerFilter {
        private List<Object> fExcludes;
        private final IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);

        public NotUsedPHPFileFilter(List<Object> excludedFiles) {
            this.fExcludes = excludedFiles;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                if (this.fExcludes != null && this.fExcludes.contains(element)) {
                    return false;
                }
                IFile file = (IFile)element;
                return this.type.isAssociatedWith(file.getName());
            }
            return true;
        }
    }
}

