/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.model.BreakpointSet;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugHandlersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.ContextManager;
import org.eclipse.php.internal.debug.core.zend.model.PHPResponseHandler;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.ServerDebugHandler;
import org.eclipse.php.internal.debug.core.zend.model.StartLock;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PHPDebugTarget
extends PHPDebugElement
implements IPHPDebugTarget,
IBreakpointManagerListener,
IStepFilters {
    private ContextManager fContextManager;
    private boolean isStepFiltersEnabled;
    private ILaunch fLaunch;
    private IProcess fProcess;
    private String fName;
    private String fURL;
    private int fRequestPort;
    private DebugOutput fDebugOutput = new DebugOutput();
    private boolean fSuspended = false;
    private boolean fTerminated = false;
    private boolean fTermainateCalled = false;
    private PHPThread fThread;
    private IThread[] fThreads;
    private IRemoteDebugger debugger;
    private String fLastcmd;
    private boolean fStatus;
    private int fLastStop;
    private String fLastFileName;
    private boolean fIsPHPCGI;
    private boolean fIsRunAsDebug;
    private PHPResponseHandler fPHPResponseHandler;
    private Debugger.StartResponseHandler fStartResponseHandler;
    private Debugger.BreakpointAddedResponseHandler fBreakpointAddedResponseHandler;
    private Debugger.BreakpointRemovedResponseHandler fBreakpointRemovedResponseHandler;
    private Debugger.StepIntoResponseHandler fStepIntoResponseHandler;
    private Debugger.StepOverResponseHandler fStepOverResponseHandler;
    private Debugger.StepOutResponseHandler fStepOutResponseHandler;
    private Debugger.GoResponseHandler fGoResponseHandler;
    private Debugger.PauseResponseHandler fPauseResponseHandler;
    private Debugger.AddFilesResponseHandler fAddFilesResponseHandler;
    private DefaultExpressionsManager expressionsManager;
    private IProject fProject;
    private int fSuspendCount;
    private Vector<IPHPConsoleEventListener> fConsoleEventListeners = new Vector();
    private Set<DebugError> fDebugErrors = new HashSet<DebugError>();
    private StartLock fStartLock = new StartLock();
    private BreakpointSet fBreakpointSet;
    private IBreakpointManager fBreakpointManager;
    private boolean fIsServerWindows = false;
    private DebugConnection fDebugConnection;
    private Set<String> fAddFilesPaths;

    public PHPDebugTarget(DebugConnection connection, ILaunch launch, String URL2, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        super(null);
        this.fDebugConnection = connection;
        this.fURL = URL2;
        this.fIsPHPCGI = false;
        this.initDebugTarget(launch, requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public PHPDebugTarget(DebugConnection connectionThread, ILaunch launch, String phpExe, IFile fileToDebug, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        this(connectionThread, launch, phpExe, fileToDebug.getName(), requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public PHPDebugTarget(DebugConnection connectionThread, ILaunch launch, String phpExe, String fileToDebug, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        super(null);
        this.fDebugConnection = connectionThread;
        this.fName = fileToDebug;
        this.fIsPHPCGI = true;
        this.initDebugTarget(launch, requestPort, process, runAsDebug, stopAtFirstLine, project);
    }

    public DebugConnection getDebugConnection() {
        return this.fDebugConnection;
    }

    private void initDebugTarget(ILaunch launch, int requestPort, IProcess process, boolean runAsDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        String debugHandlerID;
        this.fLaunch = launch;
        this.fProcess = process;
        this.fIsRunAsDebug = runAsDebug;
        this.fProject = project;
        this.fProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
        if (this.fProcess instanceof PHPProcess) {
            ((PHPProcess)this.fProcess).setDebugTarget(this);
        }
        this.fRequestPort = requestPort;
        this.fBreakpointSet = new BreakpointSet(project, this.fIsPHPCGI);
        IDebugHandler debugHandler = null;
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        if (parametersInitializer != null && (debugHandlerID = parametersInitializer.getDebugHandler()) != null) {
            try {
                debugHandler = DebugHandlersRegistry.getHandler(debugHandlerID);
            }
            catch (Exception e) {
                PHPDebugPlugin.log(e);
            }
        }
        if (debugHandler == null) {
            debugHandler = new ServerDebugHandler();
        }
        debugHandler.setDebugTarget(this);
        this.debugger = debugHandler.getRemoteDebugger();
        this.fThread = new PHPThread(this);
        this.fThreads = new IThread[]{this.fThread};
        this.fTerminated = false;
        this.fPHPResponseHandler = new PHPResponseHandler(this);
        this.fStartResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.StartResponseHandler();
        this.fBreakpointAddedResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.BreakpointAddedResponseHandler();
        this.fBreakpointRemovedResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.BreakpointRemovedResponseHandler();
        this.fStepIntoResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.StepIntoResponseHandler();
        this.fStepOverResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.StepOverResponseHandler();
        this.fStepOutResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.StepOutResponseHandler();
        this.fGoResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.GoResponseHandler();
        this.fPauseResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.PauseResponseHandler();
        this.fAddFilesResponseHandler = this.fPHPResponseHandler.new PHPResponseHandler.AddFilesResponseHandler();
        this.fSuspendCount = 0;
        this.fContextManager = new ContextManager(this, this.debugger);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fAddFilesPaths = new HashSet<String>();
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.debugger;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return !this.fTerminated && this.fThreads.length > 0;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.fURL;
        }
        return this.fName;
    }

    public String getURL() {
        return this.fURL;
    }

    int getLastStop() {
        return this.fLastStop;
    }

    public String getLastFileName() {
        return this.fLastFileName;
    }

    public int getSuspendCount() {
        return this.fSuspendCount;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            if (breakpoint instanceof IPHPExceptionBreakpoint) {
                return false;
            }
            boolean support = this.fBreakpointSet.supportsBreakpoint(breakpoint);
            return support;
        }
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        StartLock startLock = this.getStartLock();
        if (!startLock.isStarted()) {
            this.terminated();
            this.fTermainateCalled = true;
            return;
        }
        IThread[] threads = this.getThreads();
        if (threads != null && threads.length > 0) {
            ((PHPThread)threads[0]).setStepping(false);
        }
        this.fTerminated = true;
        this.fSuspended = false;
        this.fLastcmd = "terminate";
        Logger.debugMSG("PHPDebugTarget: Calling closeDebugSession()");
        this.debugger.closeDebugSession();
        this.terminated();
        this.fTermainateCalled = true;
    }

    public void terminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        Logger.debugMSG("PHPDebugTarget: Calling debugger.closeConnection()");
        if (!this.fTermainateCalled) {
            this.debugger.closeConnection();
        }
        this.completeTerminated();
        PHPSessionLaunchMapper.updateSystemProperty(DebugPlugin.getDefault().getLaunchManager().getLaunches());
    }

    private void completeTerminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        this.fThreads = new IThread[0];
        Logger.debugMSG("PHPDebugTarget: Calling removeBreakpointListener(this);");
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        Logger.debugMSG("PHPDebugTarget: Firing terminate");
        this.fireTerminateEvent();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                if (page == null) {
                    return;
                }
                AbstractDebugView view = (AbstractDebugView)page.findView("org.eclipse.debug.ui.DebugView");
                if (view == null) {
                    return;
                }
                view.getViewer().refresh();
            }
        });
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.fLastcmd = "resume";
        int detail = 32;
        this.resumed(detail);
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.go(this.fGoResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.go return false");
        }
    }

    private void resumed(int detail) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(detail);
    }

    public void suspended(int detail) {
        this.fSuspended = true;
        ++this.fSuspendCount;
        System.setProperty("org.eclipse.debugger.variables", "true");
        try {
            ((PHPThread)this.getThreads()[0]).setStepping(false);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        this.fThread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
        this.fLastcmd = "suspend";
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.pause(this.fPauseResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.pause return false");
        }
        int detail = 32;
        this.suspended(detail);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.fLastcmd = "breakpointAdded";
                    PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
                    IMarker marker = bp.getMarker();
                    Breakpoint runtimeBreakpoint = bp.getRuntimeBreakpoint();
                    int lineNumber = runtimeBreakpoint.getLineNumber();
                    String fileName = null;
                    if (breakpoint instanceof PHPRunToLineBreakpoint) {
                        PHPRunToLineBreakpoint rtl = (PHPRunToLineBreakpoint)breakpoint;
                        IFile resource = rtl.getSourceFile();
                        fileName = resource.getFullPath().toString();
                    } else {
                        lineNumber = marker.getAttribute("lineNumber", 0);
                        runtimeBreakpoint.setLineNumber(lineNumber);
                    }
                    if (fileName == null) {
                        fileName = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", (String)marker.getAttribute("location"));
                        IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)Path.fromPortableString((String)fileName));
                        fileName = localPath.toString();
                    }
                    fileName = RemoteDebugger.convertToRemoteFilename(fileName, this);
                    runtimeBreakpoint.setFileName(fileName);
                    Logger.debugMSG("PHPDebugTarget: Setting Breakpoint - File " + fileName + " Line Number " + lineNumber);
                    this.debugger.addBreakpoint(bp.getRuntimeBreakpoint(), this.fBreakpointAddedResponseHandler);
                }
            }
            catch (CoreException e1) {
                Logger.logException("PHPDebugTarget: Exception Adding Breakpoint", e1);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            if (breakpoint instanceof PHPRunToLineBreakpoint) {
                return;
            }
            this.fLastcmd = "breakpointRemoved";
            PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
            Breakpoint runtimeBreakpoint = bp.getRuntimeBreakpoint();
            Logger.debugMSG("PHPDebugTarget: Removing Breakpoint - File " + runtimeBreakpoint.getFileName() + " Line Number " + runtimeBreakpoint.getLineNumber());
            this.fStatus = this.debugger.removeBreakpoint(runtimeBreakpoint, this.fBreakpointRemovedResponseHandler);
            if (!this.fStatus && this.debugger.isActive()) {
                Logger.log(4, "PHPDebugTarget: debugger.removeBreakpoint return false");
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.fBreakpointManager.isEnabled()) {
            return;
        }
        int deltaLNumber = delta.getAttribute("lineNumber", 0);
        IMarker marker = breakpoint.getMarker();
        int lineNumber = marker.getAttribute("lineNumber", 0);
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (((PHPLineBreakpoint)breakpoint).isConditionChanged()) {
                    ((PHPLineBreakpoint)breakpoint).setConditionChanged(false);
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (lineNumber != deltaLNumber) {
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException e) {
                Logger.logException("PHPDebugTarget: Exception Changing Breakpoint", e);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void started() {
        this.fSuspended = false;
        this.fireCreationEvent();
    }

    public void installDeferredBreakpoints() throws CoreException {
    }

    protected IStackFrame[] getStackFrames() throws DebugException {
        return this.fContextManager.getStackFrames();
    }

    public DefaultExpressionsManager getExpressionManager() {
        return this.expressionsManager;
    }

    public void setExpressionManager(DefaultExpressionsManager expressionManager) {
        this.expressionsManager = expressionManager;
    }

    protected void stepReturn() throws DebugException {
        this.fLastcmd = "stepReturn";
        Logger.debugMSG("PHPDebugTarget: stepReturn ");
        int detail = 4;
        this.resumed(detail);
        this.fStatus = this.debugger.stepOut(this.fStepOutResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOut return false");
        }
    }

    protected void stepOver() throws DebugException {
        this.fLastcmd = "stepOver";
        Logger.debugMSG("PHPDebugTarget: stepOver");
        int detail = 2;
        this.resumed(detail);
        this.fStatus = this.debugger.stepOver(this.fStepOverResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOver return false");
        }
    }

    protected void stepInto() throws DebugException {
        Logger.debugMSG("PHPDebugTarget: stepInto ");
        this.fLastcmd = "stepInto";
        int detail = 1;
        this.resumed(detail);
        this.fStatus = this.debugger.stepInto(this.fStepIntoResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepInto return false");
        }
    }

    public IVariable[] getVariables(PHPStackFrame stackFrame) {
        return this.fContextManager.getVariables(stackFrame);
    }

    public void breakpointHit(String fileName, int lineNumber) {
        IBreakpoint breakpoint = this.findBreakpoint(fileName, lineNumber);
        if (breakpoint != null) {
            this.fThread.setBreakpoints(new IBreakpoint[]{breakpoint});
        } else {
            this.fThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    protected IBreakpoint findBreakpoint(String fileName, int lineNumber) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint lineBreakpoint = (PHPLineBreakpoint)breakpoint;
                Breakpoint zBP = lineBreakpoint.getRuntimeBreakpoint();
                String bFileName = zBP.getFileName();
                int bLineNumber = zBP.getLineNumber();
                if (bLineNumber == lineNumber && bFileName.equals(fileName)) {
                    return breakpoint;
                }
            }
            ++n2;
        }
        return null;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint element = iBreakpointArray[n2];
            if (this.supportsBreakpoint(element)) {
                if (enabled) {
                    ((PHPLineBreakpoint)element).setConditionChanged(false);
                    this.breakpointAdded(element);
                } else {
                    this.breakpointRemoved(element, null);
                }
            }
            ++n2;
        }
    }

    public void addConsoleEventListener(IPHPConsoleEventListener listener) {
        if (!this.fConsoleEventListeners.contains(listener)) {
            this.fConsoleEventListeners.add(listener);
        }
        for (DebugError debugError : this.fDebugErrors) {
            listener.handleEvent(debugError);
        }
    }

    public void removeConsoleEventListener(IPHPConsoleEventListener listener) {
        this.fConsoleEventListeners.remove(listener);
    }

    public List<IPHPConsoleEventListener> getConsoleEventListeners() {
        return this.fConsoleEventListeners;
    }

    @Override
    public DebugOutput getOutputBuffer() {
        return this.fDebugOutput;
    }

    public boolean isRunWithDebug() {
        return this.fIsRunAsDebug;
    }

    public void fireError(String errorMessage, Exception e1) {
        Status status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e1);
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void fireError(IStatus status) {
        DebugEvent event = new DebugEvent((Object)this, 32);
        event.setData((Object)status);
        this.fireEvent(event);
    }

    public void setLastStop(int lineNumber) {
        this.fLastStop = lineNumber;
    }

    public void setLastFileName(String string) {
        this.fLastFileName = string;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fThread.setBreakpoints(new IBreakpoint[0]);
    }

    public boolean isPHPCGI() {
        return this.fIsPHPCGI;
    }

    public StartLock getStartLock() {
        return this.fStartLock;
    }

    public void setLastCommand(String command) {
        this.fLastcmd = command;
    }

    public String getLastCommand() {
        return this.fLastcmd;
    }

    public int getRequestPort() {
        return this.fRequestPort;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public Collection<DebugError> getDebugErrors() {
        return this.fDebugErrors;
    }

    public boolean isServerWindows() {
        return this.fIsServerWindows;
    }

    public void setServerWindows(boolean isServerWindows) {
        this.fIsServerWindows = isServerWindows;
    }

    public Debugger.StartResponseHandler getStartResponseHandler() {
        return this.fStartResponseHandler;
    }

    public Debugger.AddFilesResponseHandler getAddFilesResponseHandler() {
        return this.fAddFilesResponseHandler;
    }

    public ContextManager getContextManager() {
        return this.fContextManager;
    }

    public IBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    public PathEntry mapFirstDebugFile(String remoteFile) {
        block14: {
            if (this.getContextManager().isResolveBlacklisted(remoteFile)) {
                return null;
            }
            try {
                ILaunchConfiguration launchConfiguration = this.getLaunch().getLaunchConfiguration();
                PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(launchConfiguration);
                if (pathMapper == null) break block14;
                PathEntry pathEntry = pathMapper.getLocalFile(remoteFile);
                if (pathEntry == null) {
                    String debugFileName = launchConfiguration.getAttribute("file_name", null);
                    if (debugFileName == null) {
                        debugFileName = launchConfiguration.getAttribute("ATTR_FILE", null);
                    }
                    if (debugFileName != null) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(debugFileName);
                        if (resource instanceof IFile) {
                            pathEntry = new PathEntry(debugFileName, PathEntry.Type.WORKSPACE, (Object)resource.getParent());
                        } else if (new File(debugFileName).exists()) {
                            pathEntry = new PathEntry(debugFileName, PathEntry.Type.EXTERNAL, (Object)new File(debugFileName).getParentFile());
                        }
                    }
                    if (pathEntry != null) {
                        pathMapper.addEntry(remoteFile, pathEntry, PathMapper.Mapping.MappingSource.ENVIRONMENT);
                        PathMapperRegistry.storeToPreferences();
                    } else {
                        pathEntry = DebugSearchEngine.find(remoteFile, this);
                    }
                }
                if (this.getProject() == null && pathEntry != null && pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(pathEntry.getPath());
                    IProject project = resource.getProject();
                    this.setProject(project);
                    try {
                        ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                        wc.getAttribute("org.eclipse.php.debug.core.PHP_Project", project.getName());
                        wc.doSave();
                    }
                    catch (CoreException e) {
                        PHPDebugPlugin.log(e);
                    }
                }
                return pathEntry;
            }
            catch (Exception e) {
                PHPDebugPlugin.log(e);
            }
        }
        return null;
    }

    public boolean isStepFiltersEnabled() {
        return this.isStepFiltersEnabled;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.isStepFiltersEnabled = enabled;
    }

    public boolean supportsStepFilters() {
        return this.isStepFiltersEnabled;
    }

    @Override
    public boolean isWaiting() {
        return false;
    }

    public boolean isFirstBreakpointAdded(IBreakpoint breakpoint) {
        return this.fAddFilesPaths.size() == 0;
    }

    public void addBreakpointFiles(IProject ... projects) {
        if (this.debugger.getCurrentProtocolID() >= 2012121702) {
            ArrayList<String> paths = new ArrayList<String>();
            try {
                if (this.fBreakpointManager.isEnabled()) {
                    ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(Arrays.asList(this.fBreakpointManager.getBreakpoints("org.eclipse.php.debug.core")));
                    if (breakpoints != null && breakpoints.size() > 0) {
                        IProject[] iProjectArray = projects;
                        int n = projects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            this.getBreakpointFiles((IContainer)project, paths, breakpoints);
                            this.getBreakpointsIncludePath(project, paths, breakpoints);
                            ++n2;
                        }
                        int oldSize = this.fAddFilesPaths.size();
                        this.fAddFilesPaths.addAll(paths);
                        if (oldSize < this.fAddFilesPaths.size()) {
                            this.debugger.addFiles(this.fAddFilesPaths.toArray(new String[this.fAddFilesPaths.size()]));
                        }
                    } else if (this.fLastFileName != null) {
                        this.debugger.addFiles(new String[]{this.fLastFileName});
                    }
                }
            }
            catch (CoreException e) {
                PHPDebugPlugin.log(e);
            }
        }
    }

    private void getBreakpointsIncludePath(IProject container, List<String> paths, List<IBreakpoint> breakpoints) throws CoreException {
        String localFile;
        if (container == null && (localFile = ((RemoteDebugger)this.debugger).convertToLocalFilename(this.fLastFileName)) != null) {
            Path localPath = new Path(localFile);
            String projectName = localPath.segment(0);
            container = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (container == null || !container.exists()) {
                return;
            }
        }
        List<IPath> includePaths = ((RemoteDebugger)this.debugger).getIncludePaths(this.fProject);
        for (IBreakpoint bp : breakpoints) {
            String secondaryId = (String)bp.getMarker().getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
            if (secondaryId == null) continue;
            IPath path = Path.fromPortableString((String)secondaryId);
            if (path.getDevice() == null && path.toString().startsWith("org.eclipse.dltk")) {
                String fullPathString = path.toString();
                String absolutePath = fullPathString.substring(fullPathString.indexOf(58) + 1);
                path = Path.fromPortableString((String)absolutePath);
            } else {
                path = EnvironmentPathUtils.getLocalPath((IPath)path);
            }
            if (path == null) continue;
            for (IPath includePath : includePaths) {
                String remotePath;
                int size = includePath.segmentCount();
                if (path.matchingFirstSegments(includePath) != size || (remotePath = RemoteDebugger.convertToRemoteFilename(path.toString(), this)) == null || remotePath.length() <= 0) continue;
                paths.add(remotePath);
            }
        }
    }

    private void getBreakpointFiles(IContainer container, List<String> paths, List<IBreakpoint> breakpoints) throws CoreException {
        IResource[] members;
        String localFile;
        if (container == null && (localFile = ((RemoteDebugger)this.debugger).convertToLocalFilename(this.fLastFileName)) != null) {
            Path localPath = new Path(localFile);
            String projectName = localPath.segment(0);
            container = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (container == null || !container.exists()) {
                return;
            }
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IContainer) {
                this.getBreakpointFiles((IContainer)res, paths, breakpoints);
            } else {
                ArrayList<IBreakpoint> toRemove = new ArrayList<IBreakpoint>();
                for (IBreakpoint bp : breakpoints) {
                    if (!bp.getMarker().getResource().equals((Object)res)) continue;
                    String remotePath = RemoteDebugger.convertToRemoteFilename(res.getFullPath().toString(), this);
                    if (remotePath == null || remotePath.length() <= 0) break;
                    paths.add(remotePath);
                    toRemove.add(bp);
                    break;
                }
                breakpoints.removeAll(toRemove);
            }
            ++n2;
        }
    }
}

