/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.sequence.figures.ILifelineInternalFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;

public class LifeLineLayoutManager
extends AutomaticCompartmentLayoutManager {
    private int bottomHeaderY = 0;
    protected Map<IFigure, Rectangle> constraints = new HashMap<IFigure, Rectangle>();

    public int getBottomHeader() {
        return this.bottomHeaderY;
    }

    public void layout(IFigure container) {
        super.layout(container);
        this.layoutXYFigure(container);
    }

    protected void fillBoundsForOther(IFigure container, Rectangle bound, Rectangle previous) {
        bound.x = container.getBounds().x + 1;
        bound.width = container.getBounds().width;
        bound.y = previous == null ? container.getBounds().y + 3 : previous.getBottomLeft().y + 1;
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (child instanceof SelectableBorderedNodeFigure && ((SelectableBorderedNodeFigure)child).getMainFigure() instanceof ILifelineInternalFigure && constraint instanceof Rectangle) {
            this.constraints.put(child, (Rectangle)constraint);
        }
        super.setConstraint(child, constraint);
    }

    protected void fillBoundsForCompartment(IFigure container, Rectangle bound, Rectangle previous, double ratio) {
        this.fillBoundsForOther(container, bound, previous);
        if (previous == null) {
            bound.y = container.getBounds().y;
        }
    }

    protected void layoutDefault(IFigure container) {
        ScalableCompartmentFigure symbolFigure = null;
        int i = 0;
        while (symbolFigure == null && i < container.getChildren().size()) {
            if (container.getChildren().get(i) instanceof ScalableCompartmentFigure) {
                symbolFigure = (ScalableCompartmentFigure)container.getChildren().get(i);
            }
            ++i;
        }
        super.layoutDefault(container);
        if (symbolFigure != null) {
            symbolFigure.getBounds().setY(container.getBounds().getTop().y);
        }
        Rectangle containerBounds = container.getBounds();
        IFigure previous = null;
        for (IFigure child : this.visibleOthers) {
            Rectangle bound = new Rectangle();
            if (previous != null) {
                if (child.equals(symbolFigure)) {
                    bound.y = containerBounds.y + 3;
                } else {
                    bound.y = previous.getBounds().getBottomLeft().y + 1;
                    bound.x = containerBounds.x + 1;
                    bound.width = containerBounds.width;
                    bound.height = child.getBounds().height;
                    this.bottomHeaderY = bound.y + bound.height;
                }
            } else {
                bound.x = containerBounds.x + 1;
                bound.y = symbolFigure != null ? containerBounds.y + 3 + symbolFigure.getBounds().height : containerBounds.y + 3;
                bound.width = containerBounds.width;
                bound.height = child.getBounds().height;
            }
            child.setBounds(bound);
            previous = child;
        }
    }

    protected void layoutOthers(Rectangle container) {
        super.layoutOthers(container);
        IFigure previous = null;
        for (IFigure child : this.visibleOthers) {
            Rectangle bound = new Rectangle();
            if (previous != null) {
                bound.y = previous.getBounds().getBottomLeft().y + 1;
                bound.x = container.x + 1;
                bound.width = container.width;
                bound.height = child.getBounds().height;
                this.bottomHeaderY = bound.y + bound.height;
            } else {
                bound.x = container.x + 1;
                bound.y = container.y + 3;
                bound.width = container.width;
                bound.height = child.getBounds().height;
                this.bottomHeaderY = bound.y + bound.height;
            }
            child.setBounds(bound);
            previous = child;
        }
    }

    protected void layoutXYFigure(IFigure container) {
        for (Object child : container.getChildren()) {
            if (child instanceof BorderedNodeFigure) {
                Rectangle theConstraint;
                if (!(((BorderedNodeFigure)child).getMainFigure() instanceof ILifelineInternalFigure) || (theConstraint = this.constraints.get(child).getCopy()) == null) continue;
                theConstraint.translate(container.getBounds().getTopLeft());
                ((BorderedNodeFigure)child).setBounds(theConstraint);
                continue;
            }
            if (!(child instanceof LifelineFigure.LifelineHeaderFigure)) continue;
            ((LifelineFigure.LifelineHeaderFigure)((Object)child)).setBounds(container.getBounds().getCopy().setHeight(this.bottomHeaderY - container.getBounds().y + 1));
        }
    }
}

