/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.updaters.IRefactoringStep;

public class CrossReferenceUpdater
implements IRefactoringStep {
    final TransactionalEditingDomain domain;
    URI decoratorModelURI;
    URI oldUserModelURI;
    URI newUserModelURI;

    public CrossReferenceUpdater(PackageRefactoringContext context, URI decoratorModelURI) {
        this.domain = context.getEditingDomain();
        this.decoratorModelURI = decoratorModelURI;
        this.oldUserModelURI = context.getOldUserModelURI();
        this.newUserModelURI = context.getNewUserModelURI();
    }

    @Override
    public boolean refactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        return this.refactor(resource, this.oldUserModelURI, this.newUserModelURI, monitor);
    }

    @Override
    public boolean unrefactor(Resource resource, IProgressMonitor monitor) throws ExecutionException {
        return this.refactor(resource, this.newUserModelURI, this.oldUserModelURI, monitor);
    }

    protected boolean refactor(Resource resource, URI oldURI, URI newURI, IProgressMonitor monitor) throws ExecutionException {
        boolean result = false;
        monitor.beginTask(NLS.bind((String)Messages.CrossReferenceUpdater_0, (Object)this.decoratorModelURI), -1);
        Resource newUserModelResource = this.domain.getResourceSet().getResource(newURI, false);
        if (newUserModelResource != null && newUserModelResource.isLoaded()) {
            Predicate<EReference> needsRefactoring = CrossReferenceUpdater.needsRefactoring();
            TreeIterator all = resource.getAllContents();
            while (all.hasNext()) {
                EObject next = (EObject)all.next();
                for (EReference ref : Iterables.filter((Iterable)next.eClass().getEAllReferences(), needsRefactoring)) {
                    if (!next.eIsSet((EStructuralFeature)ref)) continue;
                    if (ref.isMany()) {
                        for (Object xref : (Iterable)next.eGet((EStructuralFeature)ref)) {
                            EObject eXRef = (EObject)xref;
                            if (!eXRef.eIsProxy()) continue;
                            boolean bl = result = this.refactor(eXRef, oldURI, newURI, newUserModelResource) || result;
                        }
                        continue;
                    }
                    EObject eXRef = (EObject)next.eGet((EStructuralFeature)ref);
                    if (eXRef == null || !eXRef.eIsProxy()) continue;
                    boolean bl = result = this.refactor(eXRef, oldURI, newURI, newUserModelResource) || result;
                }
            }
        }
        return result;
    }

    boolean refactor(EObject xref, URI oldURI, URI newURI, Resource newUserModelResource) {
        String fragment;
        EObject target;
        boolean result = false;
        InternalEObject proxy = (InternalEObject)xref;
        URI proxyURI = proxy.eProxyURI();
        if (proxyURI.trimFragment().equals(oldURI) && (target = newUserModelResource.getEObject(fragment = proxyURI.fragment())) != null) {
            proxy.eSetProxyURI(newURI.appendFragment(fragment));
            result = true;
        }
        return result;
    }

    static Predicate<EReference> needsRefactoring() {
        return new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return input != null && input.isChangeable() && !input.isDerived() && !input.isContainment() && !input.isContainer();
            }
        };
    }
}

