/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collections;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class InputDialog
extends SelectionDialog {
    protected String initialValue;
    protected IInputValidator validator;
    protected Label errorLabel;
    protected Label errorImage;
    protected AbstractValueEditor editor;
    protected String title;
    protected String labelText;
    protected IStaticContentProvider contentProvider;

    public InputDialog(Shell parentShell, String title, String label, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.initialValue = initialValue;
        this.validator = validator;
        this.title = title;
        this.labelText = label;
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void create() {
        super.create();
        ((GridLayout)this.getDialogArea().getLayout()).numColumns = 2;
        this.errorImage = new Label(this.getDialogArea(), 0);
        this.errorImage.setImage(Activator.getDefault().getImage("/icons/error.gif"));
        this.errorLabel = new Label(this.getDialogArea(), 0);
        this.errorLabel.setVisible(false);
        Label label = new Label(this.getDialogArea(), 0);
        if (this.labelText != null) {
            label.setText(this.labelText);
        }
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        if (this.contentProvider != null) {
            this.editor = new StringCombo(this.getDialogArea(), 2048);
            ((StringCombo)this.editor).setValue(this.initialValue);
            ((StringCombo)this.editor).setContentProvider(this.contentProvider);
        } else {
            this.editor = new StringEditor(this.getDialogArea(), 2048){

                public void addKeyListener(KeyListener keyListener) {
                    this.text.addKeyListener(keyListener);
                }
            };
            ((StringEditor)this.editor).setValue(this.initialValue);
        }
        this.editor.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.editor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                InputDialog.this.validate();
            }
        });
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        this.validate();
        this.getShell().pack();
    }

    protected void validate() {
        if (this.validator == null) {
            this.errorLabel.setVisible(false);
            this.errorImage.setVisible(false);
            this.getOkButton().setEnabled(true);
            return;
        }
        String errorMessage = this.validator.isValid((String)this.editor.getValue());
        if (errorMessage == null) {
            this.errorLabel.setVisible(false);
            this.errorImage.setVisible(false);
            this.getOkButton().setEnabled(true);
        } else {
            this.errorLabel.setText(errorMessage);
            this.errorLabel.setVisible(true);
            this.errorImage.setVisible(true);
            this.getOkButton().setEnabled(false);
        }
        this.getDialogArea().layout(true);
    }

    protected void okPressed() {
        this.setResult(Collections.singletonList((String)this.editor.getValue()));
        super.okPressed();
    }

    public String getText() {
        Object[] result = this.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (String)result[0];
    }

    public void setContentProvider(IStaticContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }
}

