/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneCommandAnalyzer;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;

public class StandaloneApplication
implements IApplication {
    private static final String ARGS_KEY = "application.args";
    private OCL ocl = null;
    private final @NonNull StandaloneCommandAnalyzer commandAnalyzer = new StandaloneCommandAnalyzer(this);

    public StandaloneApplication() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ValidityExporterRegistry.initialize((ValidityExporterRegistry)ValidityExporterRegistry.INSTANCE);
        }
    }

    public void doCompleteOCLSetup() {
        this.getOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompleteOCLStandaloneSetup.doSetup();
        }
    }

    public @NonNull StandaloneResponse execute(@NonNull String @NonNull [] args) {
        StandaloneCommand command = this.commandAnalyzer.parse(args);
        if (command == null) {
            return StandaloneResponse.FAIL;
        }
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = command.parse(args);
        if (token2strings == null) {
            return StandaloneResponse.FAIL;
        }
        boolean isOk = command.check(token2strings);
        if (!isOk) {
            return StandaloneResponse.FAIL;
        }
        return command.execute(token2strings);
    }

    public @NonNull Collection<StandaloneCommand> getCommands() {
        return this.commandAnalyzer.getCommands();
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.getOCL().getEnvironmentFactory();
    }

    public @NonNull OCL getOCL() {
        if (this.ocl == null) {
            this.ocl = OCL.newInstance();
        }
        return this.ocl;
    }

    public @NonNull ResourceSet getResourceSet() {
        return this.getOCL().getResourceSet();
    }

    public Resource loadModelFile(URI fileUri) {
        Resource loadedResource = this.ocl.getResourceSet().getResource(fileUri, true);
        if (!loadedResource.isLoaded()) {
            return null;
        }
        return loadedResource;
    }

    public Resource loadOCLFile(URI oclUri) {
        Resource loadedResource = this.getResourceSet().getResource(oclUri, true);
        if (!loadedResource.isLoaded()) {
            return null;
        }
        return loadedResource;
    }

    public Object start(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get(ARGS_KEY);
        StandaloneResponse applicationCodeResponse = this.execute(args);
        if (StandaloneResponse.OK.equals((Object)applicationCodeResponse)) {
            return IApplication.EXIT_OK;
        }
        return IApplication.EXIT_RELAUNCH;
    }

    public void stop() {
        if (this.ocl != null) {
            this.ocl.dispose();
            this.ocl = null;
        }
    }
}

