/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codelens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.codelens.LSPCodeMining;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class CodeLensProvider
extends AbstractCodeMiningProvider {
    private CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(@NonNull IDocument document) {
        return CompletableFuture.supplyAsync(() -> {
            List<@NonNull LanguageServiceAccessor.LSPDocumentInfo> docInfos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> capabilities.getCodeLensProvider() != null);
            CompletableFuture[] requests = new CompletableFuture[docInfos.size()];
            List codeLensResults = Collections.synchronizedList(new ArrayList(docInfos.size()));
            int i = 0;
            while (i < docInfos.size()) {
                LanguageServiceAccessor.LSPDocumentInfo info = docInfos.get(i);
                ServerCapabilities capabilites = info.getCapabilites();
                CodeLensParams param = new CodeLensParams(new TextDocumentIdentifier(info.getFileUri().toString()));
                requests[i] = ((CompletableFuture)info.getInitializedLanguageClient().thenCompose(languageServer -> languageServer.getTextDocumentService().codeLens(param))).thenAccept(codeLenses -> {
                    for (CodeLens codeLens : codeLenses) {
                        if (codeLens == null || capabilites == null) continue;
                        try {
                            codeLensResults.add(new LSPCodeMining(codeLens, document, info.getInitializedLanguageClient(), capabilites.getCodeLensProvider(), this));
                        }
                        catch (BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                });
                ++i;
            }
            CompletableFuture.allOf(requests).join();
            return codeLensResults;
        });
    }

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return this.provideCodeMinings(viewer.getDocument());
    }
}

