/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

public abstract class DSPDebugElement
extends DebugElement {
    private String errorMessage;

    public DSPDebugElement(DSPDebugTarget target) {
        super((IDebugTarget)target);
    }

    public String getModelIdentifier() {
        return "org.eclipse.lsp4e.debug.model";
    }

    public DSPDebugTarget getDebugTarget() {
        return (DSPDebugTarget)super.getDebugTarget();
    }

    public IDebugProtocolServer getDebugProtocolServer() {
        return this.getDebugTarget().getDebugProtocolServer();
    }

    protected IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    static <T> T complete(CompletableFuture<T> future) throws DebugException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw DSPDebugElement.newTargetRequestFailedException("Failed to get result from target", e);
        }
    }

    static <T> T monitorGet(CompletableFuture<T> future, IProgressMonitor monitor) throws DebugException {
        try {
            while (true) {
                if (monitor.isCanceled()) {
                    future.cancel(true);
                    return future.get();
                }
                try {
                    return future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                break;
            }
        }
        catch (CancellationException e) {
            throw new DebugException((IStatus)new Status(8, "org.eclipse.lsp4e.debug", 5010, "Cancelled", (Throwable)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.cancel(true);
            throw new DebugException((IStatus)new Status(8, "org.eclipse.lsp4e.debug", 5010, "Interrupted", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.lsp4e.debug", 5010, "Unexpected exception", (Throwable)e));
        }
    }

    static DebugException newTargetRequestFailedException(String message, Throwable e) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, message, e));
    }

    protected void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

