/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.model.value;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jpt.common.core.internal.utility.ResourceChangeAdapter;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

public class WorkspaceProjectsModel
extends AbstractCollectionValueModel
implements CollectionValueModel<IProject> {
    private final IWorkspace workspace;
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private final Vector<IProject> projects = new Vector();

    public WorkspaceProjectsModel(IWorkspaceRoot workspaceRoot) {
        this(workspaceRoot.getWorkspace());
    }

    public WorkspaceProjectsModel(IWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException();
        }
        this.workspace = workspace;
    }

    public Iterator<IProject> iterator() {
        return IteratorTools.clone(this.projects);
    }

    public int size() {
        return this.projects.size();
    }

    protected void engageModel() {
        this.workspace.addResourceChangeListener(this.resourceChangeListener, 1);
        CollectionTools.addAll(this.projects, (Object[])this.workspace.getRoot().getProjects());
    }

    protected void disengageModel() {
        this.workspace.removeResourceChangeListener(this.resourceChangeListener);
        this.projects.clear();
    }

    void projectAdded(IProject project) {
        this.addItemToCollection(project, this.projects, "values");
    }

    void projectRemoved(IProject project) {
        this.removeItemFromCollection(project, this.projects, "values");
    }

    class ResourceChangeListener
    extends ResourceChangeAdapter {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                this.processPostChangeDelta(event.getDelta());
            }
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProject((IProject)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processProject(IProject project, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: {
                    WorkspaceProjectsModel.this.projectAdded(project);
                    break;
                }
                case 2: {
                    WorkspaceProjectsModel.this.projectRemoved(project);
                    break;
                }
            }
        }
    }
}

