/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractStaticItemLabelProvider<M extends ItemLabelProvider.Manager>
implements ItemLabelProvider {
    private final ImageDescriptor imageDescriptor;
    private Image image;
    private boolean imageBuilt = false;
    private final String text;
    final M manager;

    AbstractStaticItemLabelProvider(String text) {
        this(null, text, null);
    }

    AbstractStaticItemLabelProvider(ImageDescriptor imageDescriptor, String text, M manager) {
        this.imageDescriptor = imageDescriptor;
        this.text = text;
        if (imageDescriptor != null && manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
    }

    @Override
    public Image getImage() {
        if (!this.imageBuilt) {
            this.imageBuilt = true;
            this.image = this.buildImage();
        }
        return this.image;
    }

    private Image buildImage() {
        return this.imageDescriptor == null ? null : this.manager.getResourceManager().createImage(this.imageDescriptor);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isLabelProperty(String property) {
        return false;
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.manager.getResourceManager().destroyImage(this.imageDescriptor);
            this.image = null;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.text);
    }
}

