/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxyFactory;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEConstructorTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFieldTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;

public class IDEMethodProxyFactory
implements IMethodProxyFactory {
    protected final IDEProxyFactoryRegistry fProxyFactoryRegistry;
    protected static final Map primLookup = new HashMap();
    IDEBeanTypeProxy accessibleType;
    IDEBeanTypeProxy fieldType;
    IDEBeanTypeProxy methodType;
    IDEBeanTypeProxy constructorType;
    static /* synthetic */ Class class$0;

    static {
        primLookup.put("int", Integer.TYPE);
        primLookup.put("char", Character.TYPE);
        primLookup.put("long", Long.TYPE);
        primLookup.put("short", Short.TYPE);
        primLookup.put("double", Double.TYPE);
        primLookup.put("boolean", Boolean.TYPE);
        primLookup.put("byte", Byte.TYPE);
        primLookup.put("float", Float.TYPE);
    }

    IDEMethodProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fProxyFactoryRegistry = aRegistry;
        this.fProxyFactoryRegistry.registerMethodProxyFactory(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.reflect.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.accessibleType = new IDEBeanTypeProxy(aRegistry, clazz);
        this.fieldType = new IDEFieldTypeProxy(aRegistry);
        this.methodType = new IDEMethodTypeProxy(aRegistry);
        this.constructorType = new IDEConstructorTypeProxy(aRegistry);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy(this.accessibleType, true);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy(this.fieldType, true);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy(this.methodType, true);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy(this.constructorType, true);
    }

    IConstructorProxy getConstructorProxy(Constructor aConstructor) {
        return (IConstructorProxy)((Object)this.constructorType.newBeanProxy(aConstructor));
    }

    IConstructorProxy[] getConstructors(Class aClass) {
        Constructor<?>[] ctors = aClass.getConstructors();
        IConstructorProxy[] ctorProxies = new IConstructorProxy[ctors.length];
        int i = 0;
        while (i < ctors.length) {
            ctorProxies[i] = this.getConstructorProxy(ctors[i]);
            ++i;
        }
        return ctorProxies;
    }

    IConstructorProxy[] getDeclaredConstructors(Class aClass) {
        Constructor<?>[] ctors = aClass.getDeclaredConstructors();
        IConstructorProxy[] ctorProxies = new IConstructorProxy[ctors.length];
        int i = 0;
        while (i < ctors.length) {
            ctorProxies[i] = this.getConstructorProxy(ctors[i]);
            ++i;
        }
        return ctorProxies;
    }

    IConstructorProxy getConstructorProxy(Class aClass, Class[] args) {
        try {
            Constructor ctor = aClass.getConstructor(args);
            return this.getConstructorProxy(ctor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    IConstructorProxy getDeclaredConstructorProxy(Class aClass, Class[] args) {
        try {
            Constructor ctor = aClass.getDeclaredConstructor(args);
            return this.getConstructorProxy(ctor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    IFieldProxy[] getFields(Class aClass) {
        Field[] fields = aClass.getFields();
        IFieldProxy[] fieldProxies = new IFieldProxy[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldProxies[i] = this.getFieldProxy(fields[i]);
            ++i;
        }
        return fieldProxies;
    }

    IFieldProxy[] getDeclaredFields(Class aClass) {
        Field[] fields = aClass.getDeclaredFields();
        IFieldProxy[] fieldProxies = new IFieldProxy[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldProxies[i] = this.getFieldProxy(fields[i]);
            ++i;
        }
        return fieldProxies;
    }

    IFieldProxy getFieldProxy(Field aField) {
        return (IFieldProxy)((Object)this.fieldType.newBeanProxy(aField));
    }

    public IProxyField getFieldProxy(IExpression expression, String className, String fieldName) {
        IStandardBeanTypeProxyFactory beanTypeProxyFactory = this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        IProxyBeanType beanType = beanTypeProxyFactory.getBeanTypeProxy(expression, className);
        return beanType.getFieldProxy(expression, fieldName);
    }

    IDEMethodProxy getMethodProxy(Method aMethod) {
        return (IDEMethodProxy)this.methodType.newBeanProxy(aMethod);
    }

    public IMethodProxy getMethodProxy(String className, String methodName, String[] parameterTypes) {
        try {
            Class aClass = this.fProxyFactoryRegistry.loadClass(className);
            return this.getMethodProxy(aClass, methodName, parameterTypes);
        }
        catch (ClassNotFoundException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IProxyMethod getMethodProxy(IExpression expression, String className, String methodName, String[] parameterTypes) {
        IStandardBeanTypeProxyFactory beanTypeProxyFactory = this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        IProxyBeanType beanType = beanTypeProxyFactory.getBeanTypeProxy(expression, className);
        IProxyBeanType[] parmTypes = this.getParameterTypes(expression, parameterTypes, beanTypeProxyFactory);
        return beanType.getMethodProxy(expression, methodName, parmTypes);
    }

    public IProxyMethod getMethodProxy(IExpression expression, IProxyBeanType classType, String methodName, String[] parameterTypes) {
        IStandardBeanTypeProxyFactory beanTypeProxyFactory = this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        IProxyBeanType[] parmTypes = this.getParameterTypes(expression, parameterTypes, beanTypeProxyFactory);
        return classType.getMethodProxy(expression, methodName, parmTypes);
    }

    protected IProxyBeanType[] getParameterTypes(IExpression expression, String[] parameterTypes, IStandardBeanTypeProxyFactory beanTypeProxyFactory) {
        IProxyBeanType[] parmTypes;
        if (parameterTypes == null || parameterTypes.length == 0) {
            parmTypes = null;
        } else {
            parmTypes = new IProxyBeanType[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                parmTypes[i] = beanTypeProxyFactory.getBeanTypeProxy(expression, parameterTypes[i]);
                ++i;
            }
        }
        return parmTypes;
    }

    public IMethodProxy getMethodProxy(Class cls, String methodName, String[] parameterTypes) {
        try {
            Class[] parmClasses = null;
            if (parameterTypes != null) {
                parmClasses = new Class[parameterTypes.length];
                int i = 0;
                while (i < parmClasses.length) {
                    Class temp = (Class)primLookup.get(parameterTypes[i]);
                    if (temp == null) {
                        temp = this.fProxyFactoryRegistry.loadClass(parameterTypes[i]);
                    }
                    parmClasses[i] = temp;
                    ++i;
                }
            }
            return this.getMethodProxy(cls.getMethod(methodName, parmClasses));
        }
        catch (ClassNotFoundException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        return null;
    }

    IMethodProxy getDeclaredMethodProxy(Class cls, String methodName, String[] parameterTypes) {
        try {
            Class[] parmClasses = null;
            if (parameterTypes != null) {
                parmClasses = new Class[parameterTypes.length];
                int i = 0;
                while (i < parmClasses.length) {
                    Class temp = (Class)primLookup.get(parameterTypes[i]);
                    if (temp == null) {
                        temp = this.fProxyFactoryRegistry.loadClass(parameterTypes[i]);
                    }
                    parmClasses[i] = temp;
                    ++i;
                }
            }
            return this.getMethodProxy(cls.getDeclaredMethod(methodName, parmClasses));
        }
        catch (ClassNotFoundException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        return null;
    }

    IDEMethodProxy getMethodProxy(Class aClass, String methodName, Class[] args) {
        try {
            Method method = aClass.getMethod(methodName, args);
            return this.getMethodProxy(method);
        }
        catch (NoSuchMethodException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unable to find method " + aClass.getName() + ":" + methodName + " args=" + args, (Throwable)exc));
            return null;
        }
    }

    IMethodProxy getDeclaredMethodProxy(Class aClass, String methodName, Class[] args) {
        try {
            Method method = aClass.getDeclaredMethod(methodName, args);
            return this.getMethodProxy(method);
        }
        catch (NoSuchMethodException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unable to find method " + aClass.getName() + ":" + methodName + " args=" + args, (Throwable)exc));
            return null;
        }
    }

    IMethodProxy getMethodProxy(IDEBeanTypeProxy aTypeProxy, String methodName, String[] parameterTypes) {
        return this.getMethodProxy(aTypeProxy.fClass, methodName, parameterTypes);
    }

    IMethodProxy[] getMethods(Class aClass) {
        Method[] methods = aClass.getMethods();
        IMethodProxy[] methodProxies = new IMethodProxy[methods.length];
        int i = 0;
        while (i < methods.length) {
            methodProxies[i] = this.getMethodProxy(methods[i]);
            ++i;
        }
        return methodProxies;
    }

    IMethodProxy getCompatibleMethod(Class aClass, String methodName, Class[] parmTypes) throws NoSuchMethodException, AmbiguousMethodException {
        Method method = MethodHelper.findCompatibleMethod(aClass, methodName, parmTypes);
        return this.getMethodProxy(method);
    }

    IConstructorProxy getCompatibleConstructor(Class aClass, Class[] parmTypes) throws AmbiguousMethodException, NoSuchMethodException, IllegalAccessException {
        Constructor method = MethodHelper.findCompatibleConstructor(aClass, parmTypes);
        return this.getConstructorProxy(method);
    }

    IMethodProxy[] getDeclaredMethods(Class aClass) {
        Method[] methods = aClass.getDeclaredMethods();
        IMethodProxy[] methodProxies = new IMethodProxy[methods.length];
        int i = 0;
        while (i < methods.length) {
            methodProxies[i] = this.getMethodProxy(methods[i]);
            ++i;
        }
        return methodProxies;
    }

    public IInvokable getInvokable(String className, String methodName, String[] parameterTypes) {
        return this.getMethodProxy(className, methodName, parameterTypes);
    }

    public void terminateFactory(boolean wait) {
    }
}

