package org.eclipse.gef.dot.internal.language.parser.antlr.lexer;

    // Hack: Use our own Lexer superclass by means of import.
    // Currently there is no other way to specify the superclass for the lexer.
    import org.eclipse.gef.dot.internal.language.parser.antlr.lexer.Lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/*******************************************************************************
 * Copyright (c) 2017, 2018 itemis AG and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Matthias Wienand (itemis AG) - initial API and implementation
 *     Tamas Miklossy   (itemis AG) - avoid lexing in infinite loop (bug #529703)
 *
 *******************************************************************************/
@SuppressWarnings("all")
public class CustomInternalDotHtmlLabelLexer extends Lexer {
    public static final int RULE_TAG_END_CLOSE=8;
    public static final int RULE_HTML_COMMENT=4;
    public static final int RULE_ATTR_VALUE=10;
    public static final int RULE_TAG_START_CLOSE=5;
    public static final int RULE_TAG_END=7;
    public static final int RULE_TAG_START=6;
    public static final int RULE_ID=11;
    public static final int RULE_WS=12;
    public static final int RULE_ASSIGN=9;
    public static final int RULE_TEXT=13;
    public static final int EOF=-1;

        boolean tagMode = false;


    // delegates
    // delegators

    public CustomInternalDotHtmlLabelLexer() {;} 
    public CustomInternalDotHtmlLabelLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public CustomInternalDotHtmlLabelLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "//opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g"; }

    // $ANTLR start "RULE_HTML_COMMENT"
    public final void mRULE_HTML_COMMENT() throws RecognitionException {
        try {
            int _type = RULE_HTML_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:18: ({...}? => ( '<!--' (~ ( '-' ) | '-' ~ ( '-' ) | '-' '-' ~ ( '>' ) )* '-->' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:20: {...}? => ( '<!--' (~ ( '-' ) | '-' ~ ( '-' ) | '-' '-' ~ ( '>' ) )* '-->' )
            {
            if ( !(( !tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_HTML_COMMENT", " !tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:36: ( '<!--' (~ ( '-' ) | '-' ~ ( '-' ) | '-' '-' ~ ( '>' ) )* '-->' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:38: '<!--' (~ ( '-' ) | '-' ~ ( '-' ) | '-' '-' ~ ( '>' ) )* '-->'
            {
            match("<!--"); 

            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:45: (~ ( '-' ) | '-' ~ ( '-' ) | '-' '-' ~ ( '>' ) )*
            loop1:
            do {
                int alt1=4;
                int LA1_0 = input.LA(1);

                if ( (LA1_0=='-') ) {
                    int LA1_1 = input.LA(2);

                    if ( (LA1_1=='-') ) {
                        int LA1_3 = input.LA(3);

                        if ( ((LA1_3>='\u0000' && LA1_3<='=')||(LA1_3>='?' && LA1_3<='\uFFFF')) ) {
                            alt1=3;
                        }


                    }
                    else if ( ((LA1_1>='\u0000' && LA1_1<=',')||(LA1_1>='.' && LA1_1<='\uFFFF')) ) {
                        alt1=2;
                    }


                }
                else if ( ((LA1_0>='\u0000' && LA1_0<=',')||(LA1_0>='.' && LA1_0<='\uFFFF')) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:46: ~ ( '-' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<=',')||(input.LA(1)>='.' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;
            	case 2 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:53: '-' ~ ( '-' )
            	    {
            	    match('-'); 
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<=',')||(input.LA(1)>='.' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;
            	case 3 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:28:64: '-' '-' ~ ( '>' )
            	    {
            	    match('-'); 
            	    match('-'); 
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='=')||(input.LA(1)>='?' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match("-->"); 


            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_HTML_COMMENT"

    // $ANTLR start "RULE_TAG_START_CLOSE"
    public final void mRULE_TAG_START_CLOSE() throws RecognitionException {
        try {
            int _type = RULE_TAG_START_CLOSE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:30:21: ( ( '</' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:30:23: ( '</' )
            {
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:30:23: ( '</' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:30:25: '</'
            {
            match("</"); 


            }

             tagMode = true; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_TAG_START_CLOSE"

    // $ANTLR start "RULE_TAG_START"
    public final void mRULE_TAG_START() throws RecognitionException {
        try {
            int _type = RULE_TAG_START;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:31:21: ( ( '<' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:31:23: ( '<' )
            {
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:31:23: ( '<' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:31:25: '<'
            {
            match('<'); 

            }

             tagMode = true; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_TAG_START"

    // $ANTLR start "RULE_TAG_END"
    public final void mRULE_TAG_END() throws RecognitionException {
        try {
            int _type = RULE_TAG_END;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:32:21: ({...}? => ( '>' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:32:23: {...}? => ( '>' )
            {
            if ( !((  tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_TAG_END", "  tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:32:39: ( '>' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:32:41: '>'
            {
            match('>'); 

            }

             tagMode = false; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_TAG_END"

    // $ANTLR start "RULE_TAG_END_CLOSE"
    public final void mRULE_TAG_END_CLOSE() throws RecognitionException {
        try {
            int _type = RULE_TAG_END_CLOSE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:33:21: ({...}? => ( '/>' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:33:23: {...}? => ( '/>' )
            {
            if ( !((  tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_TAG_END_CLOSE", "  tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:33:39: ( '/>' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:33:41: '/>'
            {
            match("/>"); 


            }

             tagMode = false; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_TAG_END_CLOSE"

    // $ANTLR start "RULE_ASSIGN"
    public final void mRULE_ASSIGN() throws RecognitionException {
        try {
            int _type = RULE_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:35:16: ({...}? => ( '=' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:35:18: {...}? => ( '=' )
            {
            if ( !(( tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_ASSIGN", " tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:35:33: ( '=' )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:35:35: '='
            {
            match('='); 

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_ASSIGN"

    // $ANTLR start "RULE_ATTR_VALUE"
    public final void mRULE_ATTR_VALUE() throws RecognitionException {
        try {
            int _type = RULE_ATTR_VALUE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:16: ({...}? => ( '\"' (~ ( '\"' ) )* '\"' | '\\'' (~ ( '\\'' ) )* '\\'' ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:18: {...}? => ( '\"' (~ ( '\"' ) )* '\"' | '\\'' (~ ( '\\'' ) )* '\\'' )
            {
            if ( !(( tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_ATTR_VALUE", " tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:33: ( '\"' (~ ( '\"' ) )* '\"' | '\\'' (~ ( '\\'' ) )* '\\'' )
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0=='\"') ) {
                alt4=1;
            }
            else if ( (LA4_0=='\'') ) {
                alt4=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:34: '\"' (~ ( '\"' ) )* '\"'
                    {
                    match('\"'); 
                    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:38: (~ ( '\"' ) )*
                    loop2:
                    do {
                        int alt2=2;
                        int LA2_0 = input.LA(1);

                        if ( ((LA2_0>='\u0000' && LA2_0<='!')||(LA2_0>='#' && LA2_0<='\uFFFF')) ) {
                            alt2=1;
                        }


                        switch (alt2) {
                    	case 1 :
                    	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:38: ~ ( '\"' )
                    	    {
                    	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='\uFFFF') ) {
                    	        input.consume();

                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;}


                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);

                    match('\"'); 

                    }
                    break;
                case 2 :
                    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:50: '\\'' (~ ( '\\'' ) )* '\\''
                    {
                    match('\''); 
                    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:55: (~ ( '\\'' ) )*
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( ((LA3_0>='\u0000' && LA3_0<='&')||(LA3_0>='(' && LA3_0<='\uFFFF')) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:36:55: ~ ( '\\'' )
                    	    {
                    	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='&')||(input.LA(1)>='(' && input.LA(1)<='\uFFFF') ) {
                    	        input.consume();

                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;}


                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);

                    match('\''); 

                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_ATTR_VALUE"

    // $ANTLR start "RULE_ID"
    public final void mRULE_ID() throws RecognitionException {
        try {
            int _type = RULE_ID;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:37:16: ({...}? => ( ( '_' | 'a' .. 'z' | 'A' .. 'Z' ) ( '_' | '-' | 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' )* ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:37:18: {...}? => ( ( '_' | 'a' .. 'z' | 'A' .. 'Z' ) ( '_' | '-' | 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' )* )
            {
            if ( !(( tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_ID", " tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:37:33: ( ( '_' | 'a' .. 'z' | 'A' .. 'Z' ) ( '_' | '-' | 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' )* )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:37:35: ( '_' | 'a' .. 'z' | 'A' .. 'Z' ) ( '_' | '-' | 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' )*
            {
            if ( (input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:37:59: ( '_' | '-' | 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( (LA5_0=='-'||(LA5_0>='0' && LA5_0<='9')||(LA5_0>='A' && LA5_0<='Z')||LA5_0=='_'||(LA5_0>='a' && LA5_0<='z')) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:
            	    {
            	    if ( input.LA(1)=='-'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);


            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_ID"

    // $ANTLR start "RULE_WS"
    public final void mRULE_WS() throws RecognitionException {
        try {
            int _type = RULE_WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:38:16: ({...}? => ( ( ' ' | '\\t' | '\\n' | '\\r' | '\\f' )+ ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:38:18: {...}? => ( ( ' ' | '\\t' | '\\n' | '\\r' | '\\f' )+ )
            {
            if ( !(( tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_WS", " tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:38:33: ( ( ' ' | '\\t' | '\\n' | '\\r' | '\\f' )+ )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:38:35: ( ' ' | '\\t' | '\\n' | '\\r' | '\\f' )+
            {
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:38:35: ( ' ' | '\\t' | '\\n' | '\\r' | '\\f' )+
            int cnt6=0;
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( ((LA6_0>='\t' && LA6_0<='\n')||(LA6_0>='\f' && LA6_0<='\r')||LA6_0==' ') ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:
            	    {
            	    if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||(input.LA(1)>='\f' && input.LA(1)<='\r')||input.LA(1)==' ' ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt6 >= 1 ) break loop6;
                        EarlyExitException eee =
                            new EarlyExitException(6, input);
                        throw eee;
                }
                cnt6++;
            } while (true);


            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_WS"

    // $ANTLR start "RULE_TEXT"
    public final void mRULE_TEXT() throws RecognitionException {
        try {
            int _type = RULE_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:10: ({...}? => ( (~ ( '<' ) )+ ) )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:12: {...}? => ( (~ ( '<' ) )+ )
            {
            if ( !(( !tagMode )) ) {
                throw new FailedPredicateException(input, "RULE_TEXT", " !tagMode ");
            }
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:28: ( (~ ( '<' ) )+ )
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:30: (~ ( '<' ) )+
            {
            // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:30: (~ ( '<' ) )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                int LA7_0 = input.LA(1);

                if ( ((LA7_0>='\u0000' && LA7_0<=';')||(LA7_0>='=' && LA7_0<='\uFFFF')) ) {
                    alt7=1;
                }


                switch (alt7) {
            	case 1 :
            	    // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:40:30: ~ ( '<' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<=';')||(input.LA(1)>='=' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_TEXT"

    public void mTokens() throws RecognitionException {
        // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:8: ( RULE_HTML_COMMENT | RULE_TAG_START_CLOSE | RULE_TAG_START | RULE_TAG_END | RULE_TAG_END_CLOSE | RULE_ASSIGN | RULE_ATTR_VALUE | RULE_ID | RULE_WS | RULE_TEXT )
        int alt8=10;
        alt8 = dfa8.predict(input);
        switch (alt8) {
            case 1 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:10: RULE_HTML_COMMENT
                {
                mRULE_HTML_COMMENT(); 

                }
                break;
            case 2 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:28: RULE_TAG_START_CLOSE
                {
                mRULE_TAG_START_CLOSE(); 

                }
                break;
            case 3 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:49: RULE_TAG_START
                {
                mRULE_TAG_START(); 

                }
                break;
            case 4 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:64: RULE_TAG_END
                {
                mRULE_TAG_END(); 

                }
                break;
            case 5 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:77: RULE_TAG_END_CLOSE
                {
                mRULE_TAG_END_CLOSE(); 

                }
                break;
            case 6 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:96: RULE_ASSIGN
                {
                mRULE_ASSIGN(); 

                }
                break;
            case 7 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:108: RULE_ATTR_VALUE
                {
                mRULE_ATTR_VALUE(); 

                }
                break;
            case 8 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:124: RULE_ID
                {
                mRULE_ID(); 

                }
                break;
            case 9 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:132: RULE_WS
                {
                mRULE_WS(); 

                }
                break;
            case 10 :
                // //opt/users/genie.gef/workspace/gef-master/gef/org.eclipse.gef.dot/src/org/eclipse/gef/dot/internal/language/parser/antlr/lexer/CustomInternalDotHtmlLabelLexer.g:1:140: RULE_TEXT
                {
                mRULE_TEXT(); 

                }
                break;

        }

    }


    protected DFA8 dfa8 = new DFA8(this);
    static final String DFA8_eotS =
        "\1\uffff\1\14\1\15\1\11\1\17\2\11\1\25\1\27\5\uffff\1\31\1\uffff"+
        "\1\11\1\33\1\uffff\1\11\1\33\1\uffff\1\25\10\uffff";
    static final String DFA8_eofS =
        "\37\uffff";
    static final String DFA8_minS =
        "\1\0\1\41\1\0\1\76\5\0\4\uffff\5\0\1\uffff\5\0\1\uffff\1\0\1\uffff"+
        "\1\0\3\uffff";
    static final String DFA8_maxS =
        "\1\uffff\1\57\1\uffff\1\76\5\uffff\4\uffff\1\0\1\uffff\1\0\2\uffff"+
        "\1\uffff\2\uffff\1\0\1\uffff\1\0\1\uffff\1\0\1\uffff\1\0\3\uffff";
    static final String DFA8_acceptS =
        "\11\uffff\1\12\1\1\1\2\1\3\5\uffff\1\7\5\uffff\1\4\1\uffff\1\6\1"+
        "\uffff\1\10\1\11\1\5";
    static final String DFA8_specialS =
        "\1\24\1\17\1\16\1\4\1\22\1\5\1\12\1\20\1\1\4\uffff\1\7\1\0\1\11"+
        "\1\23\1\2\1\uffff\1\21\1\6\1\14\1\3\1\15\1\uffff\1\10\1\uffff\1"+
        "\13\3\uffff}>";
    static final String[] DFA8_transitionS = {
            "\11\11\2\10\1\11\2\10\22\11\1\10\1\11\1\5\4\11\1\6\7\11\1\3"+
            "\14\11\1\1\1\4\1\2\2\11\32\7\4\11\1\7\1\11\32\7\uff85\11",
            "\1\12\15\uffff\1\13",
            "\74\11\1\uffff\uffc3\11",
            "\1\16",
            "\74\11\1\uffff\uffc3\11",
            "\42\20\1\21\31\20\1\22\uffc3\20",
            "\47\23\1\24\24\23\1\22\uffc3\23",
            "\55\11\1\26\2\11\12\26\2\11\1\uffff\4\11\32\26\4\11\1\26\1"+
            "\11\32\26\uff85\11",
            "\11\11\2\10\1\11\2\10\22\11\1\10\33\11\1\uffff\uffc3\11",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\74\11\1\uffff\uffc3\11",
            "\1\uffff",
            "\42\20\1\21\31\20\1\22\uffc3\20",
            "\74\11\1\uffff\uffc3\11",
            "",
            "\47\23\1\24\24\23\1\22\uffc3\23",
            "\74\11\1\uffff\uffc3\11",
            "\1\uffff",
            "\55\11\1\26\2\11\12\26\2\11\1\uffff\4\11\32\26\4\11\1\26\1"+
            "\11\32\26\uff85\11",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "",
            ""
    };

    static final short[] DFA8_eot = DFA.unpackEncodedString(DFA8_eotS);
    static final short[] DFA8_eof = DFA.unpackEncodedString(DFA8_eofS);
    static final char[] DFA8_min = DFA.unpackEncodedStringToUnsignedChars(DFA8_minS);
    static final char[] DFA8_max = DFA.unpackEncodedStringToUnsignedChars(DFA8_maxS);
    static final short[] DFA8_accept = DFA.unpackEncodedString(DFA8_acceptS);
    static final short[] DFA8_special = DFA.unpackEncodedString(DFA8_specialS);
    static final short[][] DFA8_transition;

    static {
        int numStates = DFA8_transitionS.length;
        DFA8_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA8_transition[i] = DFA.unpackEncodedString(DFA8_transitionS[i]);
        }
    }

    class DFA8 extends DFA {

        public DFA8(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 8;
            this.eot = DFA8_eot;
            this.eof = DFA8_eof;
            this.min = DFA8_min;
            this.max = DFA8_max;
            this.accept = DFA8_accept;
            this.special = DFA8_special;
            this.transition = DFA8_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( RULE_HTML_COMMENT | RULE_TAG_START_CLOSE | RULE_TAG_START | RULE_TAG_END | RULE_TAG_END_CLOSE | RULE_ASSIGN | RULE_ATTR_VALUE | RULE_ID | RULE_WS | RULE_TEXT );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA8_14 = input.LA(1);

                         
                        int index8_14 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_14>='\u0000' && LA8_14<=';')||(LA8_14>='=' && LA8_14<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 25;

                         
                        input.seek(index8_14);
                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA8_8 = input.LA(1);

                         
                        int index8_8 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_8>='\t' && LA8_8<='\n')||(LA8_8>='\f' && LA8_8<='\r')||LA8_8==' ') && ((( tagMode )||( !tagMode )))) {s = 8;}

                        else if ( ((LA8_8>='\u0000' && LA8_8<='\b')||LA8_8=='\u000B'||(LA8_8>='\u000E' && LA8_8<='\u001F')||(LA8_8>='!' && LA8_8<=';')||(LA8_8>='=' && LA8_8<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 23;

                         
                        input.seek(index8_8);
                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA8_17 = input.LA(1);

                         
                        int index8_17 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_17>='\u0000' && LA8_17<=';')||(LA8_17>='=' && LA8_17<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 27;

                         
                        input.seek(index8_17);
                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA8_22 = input.LA(1);

                         
                        int index8_22 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_22=='-'||(LA8_22>='0' && LA8_22<='9')||(LA8_22>='A' && LA8_22<='Z')||LA8_22=='_'||(LA8_22>='a' && LA8_22<='z')) && ((( tagMode )||( !tagMode )))) {s = 22;}

                        else if ( ((LA8_22>='\u0000' && LA8_22<=',')||(LA8_22>='.' && LA8_22<='/')||(LA8_22>=':' && LA8_22<=';')||(LA8_22>='=' && LA8_22<='@')||(LA8_22>='[' && LA8_22<='^')||LA8_22=='`'||(LA8_22>='{' && LA8_22<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 21;

                         
                        input.seek(index8_22);
                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA8_3 = input.LA(1);

                         
                        int index8_3 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_3=='>') && (((  tagMode )||( !tagMode )))) {s = 14;}

                        else s = 9;

                         
                        input.seek(index8_3);
                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA8_5 = input.LA(1);

                         
                        int index8_5 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_5>='\u0000' && LA8_5<='!')||(LA8_5>='#' && LA8_5<=';')||(LA8_5>='=' && LA8_5<='\uFFFF')) && ((( tagMode )||( !tagMode )))) {s = 16;}

                        else if ( (LA8_5=='\"') && ((( tagMode )||( !tagMode )))) {s = 17;}

                        else if ( (LA8_5=='<') && (( tagMode ))) {s = 18;}

                        else s = 9;

                         
                        input.seek(index8_5);
                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA8_20 = input.LA(1);

                         
                        int index8_20 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_20>='\u0000' && LA8_20<=';')||(LA8_20>='=' && LA8_20<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 27;

                         
                        input.seek(index8_20);
                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA8_13 = input.LA(1);

                         
                        int index8_13 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((  tagMode )) ) {s = 24;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_13);
                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA8_25 = input.LA(1);

                         
                        int index8_25 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((  tagMode )) ) {s = 30;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_25);
                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA8_15 = input.LA(1);

                         
                        int index8_15 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (( tagMode )) ) {s = 26;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_15);
                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA8_6 = input.LA(1);

                         
                        int index8_6 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_6>='\u0000' && LA8_6<='&')||(LA8_6>='(' && LA8_6<=';')||(LA8_6>='=' && LA8_6<='\uFFFF')) && ((( tagMode )||( !tagMode )))) {s = 19;}

                        else if ( (LA8_6=='\'') && ((( tagMode )||( !tagMode )))) {s = 20;}

                        else if ( (LA8_6=='<') && (( tagMode ))) {s = 18;}

                        else s = 9;

                         
                        input.seek(index8_6);
                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA8_27 = input.LA(1);

                         
                        int index8_27 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (( tagMode )) ) {s = 18;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_27);
                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA8_21 = input.LA(1);

                         
                        int index8_21 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (( tagMode )) ) {s = 28;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_21);
                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA8_23 = input.LA(1);

                         
                        int index8_23 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (( tagMode )) ) {s = 29;}

                        else if ( (( !tagMode )) ) {s = 9;}

                         
                        input.seek(index8_23);
                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA8_2 = input.LA(1);

                         
                        int index8_2 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_2>='\u0000' && LA8_2<=';')||(LA8_2>='=' && LA8_2<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 13;

                         
                        input.seek(index8_2);
                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA8_1 = input.LA(1);

                         
                        int index8_1 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_1=='!') && (( !tagMode ))) {s = 10;}

                        else if ( (LA8_1=='/') ) {s = 11;}

                        else s = 12;

                         
                        input.seek(index8_1);
                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA8_7 = input.LA(1);

                         
                        int index8_7 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_7=='-'||(LA8_7>='0' && LA8_7<='9')||(LA8_7>='A' && LA8_7<='Z')||LA8_7=='_'||(LA8_7>='a' && LA8_7<='z')) && ((( tagMode )||( !tagMode )))) {s = 22;}

                        else if ( ((LA8_7>='\u0000' && LA8_7<=',')||(LA8_7>='.' && LA8_7<='/')||(LA8_7>=':' && LA8_7<=';')||(LA8_7>='=' && LA8_7<='@')||(LA8_7>='[' && LA8_7<='^')||LA8_7=='`'||(LA8_7>='{' && LA8_7<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 21;

                         
                        input.seek(index8_7);
                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA8_19 = input.LA(1);

                         
                        int index8_19 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_19=='\'') && ((( tagMode )||( !tagMode )))) {s = 20;}

                        else if ( ((LA8_19>='\u0000' && LA8_19<='&')||(LA8_19>='(' && LA8_19<=';')||(LA8_19>='=' && LA8_19<='\uFFFF')) && ((( tagMode )||( !tagMode )))) {s = 19;}

                        else if ( (LA8_19=='<') && (( tagMode ))) {s = 18;}

                        else s = 9;

                         
                        input.seek(index8_19);
                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA8_4 = input.LA(1);

                         
                        int index8_4 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA8_4>='\u0000' && LA8_4<=';')||(LA8_4>='=' && LA8_4<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                        else s = 15;

                         
                        input.seek(index8_4);
                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA8_16 = input.LA(1);

                         
                        int index8_16 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_16=='\"') && ((( tagMode )||( !tagMode )))) {s = 17;}

                        else if ( ((LA8_16>='\u0000' && LA8_16<='!')||(LA8_16>='#' && LA8_16<=';')||(LA8_16>='=' && LA8_16<='\uFFFF')) && ((( tagMode )||( !tagMode )))) {s = 16;}

                        else if ( (LA8_16=='<') && (( tagMode ))) {s = 18;}

                        else s = 9;

                         
                        input.seek(index8_16);
                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA8_0 = input.LA(1);

                         
                        int index8_0 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA8_0=='<') ) {s = 1;}

                        else if ( (LA8_0=='>') && (((  tagMode )||( !tagMode )))) {s = 2;}

                        else if ( (LA8_0=='/') && (((  tagMode )||( !tagMode )))) {s = 3;}

                        else if ( (LA8_0=='=') && ((( tagMode )||( !tagMode )))) {s = 4;}

                        else if ( (LA8_0=='\"') && ((( tagMode )||( !tagMode )))) {s = 5;}

                        else if ( (LA8_0=='\'') && ((( tagMode )||( !tagMode )))) {s = 6;}

                        else if ( ((LA8_0>='A' && LA8_0<='Z')||LA8_0=='_'||(LA8_0>='a' && LA8_0<='z')) && ((( tagMode )||( !tagMode )))) {s = 7;}

                        else if ( ((LA8_0>='\t' && LA8_0<='\n')||(LA8_0>='\f' && LA8_0<='\r')||LA8_0==' ') && ((( tagMode )||( !tagMode )))) {s = 8;}

                        else if ( ((LA8_0>='\u0000' && LA8_0<='\b')||LA8_0=='\u000B'||(LA8_0>='\u000E' && LA8_0<='\u001F')||LA8_0=='!'||(LA8_0>='#' && LA8_0<='&')||(LA8_0>='(' && LA8_0<='.')||(LA8_0>='0' && LA8_0<=';')||(LA8_0>='?' && LA8_0<='@')||(LA8_0>='[' && LA8_0<='^')||LA8_0=='`'||(LA8_0>='{' && LA8_0<='\uFFFF')) && (( !tagMode ))) {s = 9;}

                         
                        input.seek(index8_0);
                        if ( s>=0 ) return s;
                        break;
            }
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 8, _s, input);
            error(nvae);
            throw nvae;
        }
    }
 

}