/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.catalog.v2;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EmfUtils {
    private EmfUtils() {
    }

    public static boolean isDataAccessible(EObject eObject) {
        boolean result = true;
        URI uri = EcoreUtil.getURI((EObject)eObject);
        if (uri.isPlatformResource()) {
            IProject project = EmfUtils.getProject(uri);
            result = project.isOpen();
        }
        return result;
    }

    public static IProject getProject(URI uri) {
        IProject result = null;
        String prjName = uri.segment(1);
        result = EmfUtils.getProject(prjName);
        if (result == null || !result.exists()) {
            String decodedPrjName = URI.decode((String)prjName);
            result = EmfUtils.getProject(decodedPrjName);
        }
        return result;
    }

    private static IProject getProject(String prjName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getProject(prjName);
    }
}

