/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmljs;

import org.eclipse.cdt.qt.core.qmljs.IJSExpression;

public interface IJSAssignmentExpression
extends IJSExpression {
    @Override
    default public String getType() {
        return "AssignmentExpression";
    }

    public AssignmentOperator getOperator();

    public IJSExpression getLeft();

    public IJSExpression getRight();

    public static enum AssignmentOperator {
        Assign("="),
        AssignAdd("+="),
        AssignSubtract("-="),
        AssignMultiply("*="),
        AssignDivide("/="),
        AssignModulus("%="),
        AssignLeftShift("<<="),
        AssignRightShift(">>="),
        AssignUnsignedRightShift(">>>="),
        AssignOr("|="),
        AssignExclusiveOr("^"),
        AssignAnd("&=");

        private final String op;

        public static AssignmentOperator fromObject(Object obj) {
            if (obj instanceof String) {
                AssignmentOperator[] assignmentOperatorArray = AssignmentOperator.values();
                int n = assignmentOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AssignmentOperator op = assignmentOperatorArray[n2];
                    if (obj.equals(op.toString())) {
                        return op;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private AssignmentOperator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

