/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.core.resources.IResource;

public class StatementHasNoEffectChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.StatementHasNoEffectProblem";
    public static final String PARAM_MACRO_ID = "macro";
    public static final String PARAM_EXCEPT_ARG_LIST = "exceptions";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckStmpVisitor());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_MACRO_ID, CheckersMessages.StatementHasNoEffectChecker_ParameterMacro, Boolean.TRUE);
        this.addListPreference(problem, PARAM_EXCEPT_ARG_LIST, CheckersMessages.GenericParameter_ParameterExceptions, CheckersMessages.GenericParameter_ParameterExceptionsItem);
    }

    private boolean isFilteredArg(String arg) {
        return this.isFilteredArg(arg, this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_EXCEPT_ARG_LIST);
    }

    private boolean shouldReportInMacro() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_MACRO_ID);
    }

    public boolean isPossibleAssignment(IASTBinaryExpression expr) {
        switch (expr.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private boolean usesOverloadedOperator(IASTBinaryExpression expr) {
        if (expr instanceof IASTImplicitNameOwner) {
            IASTImplicitName[] implicitNames = ((IASTImplicitNameOwner)expr).getImplicitNames();
            if (implicitNames.length > 0) {
                return true;
            }
            IASTExpression operand1 = expr.getOperand1();
            IASTExpression operand2 = expr.getOperand2();
            if (operand1 == null || operand2 == null) {
                return true;
            }
            if (!(operand1.getExpressionType() instanceof IBasicType) || !(operand2.getExpressionType() instanceof IBasicType)) {
                return true;
            }
        }
        return false;
    }

    private boolean usesOverloadedOperator(IASTUnaryExpression expr) {
        if (expr instanceof IASTImplicitNameOwner) {
            IASTImplicitName[] implicitNames = ((IASTImplicitNameOwner)expr).getImplicitNames();
            if (implicitNames.length > 0) {
                return true;
            }
            IASTExpression operand = expr.getOperand();
            if (operand == null) {
                return true;
            }
            if (!(operand.getExpressionType() instanceof IBasicType)) {
                return true;
            }
        }
        return false;
    }

    class CheckStmpVisitor
    extends ASTVisitor {
        CheckStmpVisitor() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTExpressionStatement) {
                IASTExpression expression = ((IASTExpressionStatement)stmt).getExpression();
                if (this.hasNoEffect(expression)) {
                    if (this.isLastExpressionInStatementExpression(expression)) {
                        return 1;
                    }
                    if (!StatementHasNoEffectChecker.this.shouldReportInMacro() && CxxAstUtils.isInMacro((IASTNode)expression)) {
                        return 1;
                    }
                    String arg = expression.getRawSignature();
                    if (StatementHasNoEffectChecker.this.isFilteredArg(arg)) {
                        return 1;
                    }
                    StatementHasNoEffectChecker.this.reportProblem(StatementHasNoEffectChecker.ER_ID, (IASTNode)stmt, new Object[]{arg});
                }
                return 1;
            }
            return 3;
        }

        private boolean isLastExpressionInStatementExpression(IASTExpression e) {
            IASTStatement[] childlist;
            IASTNode parentStmtExpr;
            IASTNode parentComp;
            IASTNode stmt = e.getParent();
            return stmt instanceof IASTExpressionStatement && (parentComp = stmt.getParent()) instanceof IASTCompoundStatement && (parentStmtExpr = parentComp.getParent()) instanceof IGNUASTCompoundStatementExpression && stmt == (childlist = ((IASTCompoundStatement)parentComp).getStatements())[childlist.length - 1];
        }

        private boolean hasNoEffect(IASTExpression e) {
            if (e instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExpr = (IASTBinaryExpression)e;
                if (StatementHasNoEffectChecker.this.isPossibleAssignment(binExpr)) {
                    return false;
                }
                if (StatementHasNoEffectChecker.this.usesOverloadedOperator(binExpr)) {
                    return false;
                }
                switch (binExpr.getOperator()) {
                    case 15: 
                    case 16: {
                        return this.hasNoEffect(binExpr.getOperand1()) && this.hasNoEffect(binExpr.getOperand2());
                    }
                }
                return true;
            }
            if (e instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpr = (IASTUnaryExpression)e;
                if (StatementHasNoEffectChecker.this.usesOverloadedOperator(unaryExpr)) {
                    return false;
                }
                int operator = unaryExpr.getOperator();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return false;
                    }
                    case 11: {
                        return this.hasNoEffect(unaryExpr.getOperand());
                    }
                }
                return true;
            }
            return e instanceof IASTIdExpression;
        }
    }
}

