/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.content.IStyleListener;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableCellElementImpl
extends ODFStylableElementImpl
implements TableCellElement {
    private static final long serialVersionUID = -4617536939760820397L;

    protected TableCellElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public int getTableIndex() {
        TableElement tableElement = this.getTableElement();
        return tableElement.getTableIndex();
    }

    @Override
    public TableElement getTableElement() {
        TableElement tableElement = null;
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof TableElement) {
                tableElement = (TableElement)node;
                break;
            }
            node = node.getParentNode();
        }
        return tableElement;
    }

    @Override
    public int getTableColIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> list = tableElement.getTableRowChildren();
        if (list == null) {
            return -1;
        }
        int n = 0;
        while (n < list.size()) {
            TableRowElement tableRowElement = list.get(n);
            List<TableCellElement> list2 = tableRowElement.getTableCellChildren();
            if (list2 != null) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    if (list2.get(n2).equals(this)) {
                        return n2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getTableRowIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> list = tableElement.getTableRowChildren();
        if (list == null) {
            return -1;
        }
        int n = 0;
        while (n < list.size()) {
            TableRowElement tableRowElement = list.get(n);
            List<TableCellElement> list2 = tableRowElement.getTableCellChildren();
            if (list2 != null) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    if (list2.get(n2).equals(this)) {
                        return n;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getTableColSize() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> list = tableElement.getTableRowChildren();
        if (list == null) {
            return -1;
        }
        int n = 0;
        while (n < list.size()) {
            TableRowElement tableRowElement = list.get(n);
            List<TableCellElement> list2 = tableRowElement.getTableCellChildren();
            if (list2 != null) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    if (list2.get(n2).equals(this)) {
                        return list2.size();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getTableRowSize() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        List<TableRowElement> list = tableElement.getTableRowChildren();
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    @Override
    public String getAttrOfficeValue() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value");
        }
        return null;
    }

    @Override
    public String getAttrOfficeValueType() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
        }
        return null;
    }

    @Override
    public String getAttrTableFormula() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "formula")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "formula");
        }
        return null;
    }

    @Override
    public int getAttrTableNumberColumnsRepeated() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated"));
        }
        return -1;
    }

    @Override
    public int getAttrTableNumberColumnsSpanned() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned"));
        }
        return -1;
    }

    @Override
    public void setValue(String string) {
        this.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value", string);
    }

    @Override
    public String getValue() {
        return this.getAttrOfficeValue();
    }

    @Override
    public void setStyle(StyleElement styleElement) {
    }

    @Override
    public StyleElement getStyle() {
        String string;
        ODFElement oDFElement;
        Element element = this.getOwnerDocument().getDocumentElement();
        if (element instanceof ODFElementImpl && (oDFElement = ((ODFElementImpl)element).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string = this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name"))) != null && oDFElement instanceof StyleElement) {
            return (StyleElement)oDFElement;
        }
        return null;
    }

    @Override
    public void addStyleListener(IStyleListener iStyleListener, String string) {
    }

    @Override
    public void removeStyleListener(IStyleListener iStyleListener, String string) {
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

