/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.CompositeModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Node;

public class OrModelGroup
extends CompositeModelGroup {
    public OrModelGroup(IModelGroup iModelGroup) {
        super(iModelGroup);
        if (iModelGroup instanceof OrModelGroup) {
            OrModelGroup orModelGroup = (OrModelGroup)iModelGroup;
            this.childLength = orModelGroup.childLength;
            int n = 0;
            while (n < this.childLength) {
                this.children[n] = orModelGroup.children[n];
                ++n;
            }
        }
    }

    public void add(IModelGroup iModelGroup) {
        if (iModelGroup instanceof OrModelGroup) {
            OrModelGroup orModelGroup = (OrModelGroup)iModelGroup;
            int n = 0;
            while (n < orModelGroup.childLength) {
                this.children[this.childLength++] = orModelGroup.children[n];
                ++n;
            }
        } else {
            this.children[this.childLength++] = iModelGroup;
        }
    }

    public ElementDefinition[] getChildren() throws ParseException {
        ElementDefinition[] elementDefinitionArray = new ElementDefinition[this.childLength];
        int n = 0;
        while (n < this.childLength) {
            elementDefinitionArray[n] = (ElementDefinition)this.children[n];
            ++n;
        }
        return elementDefinitionArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int n = 0;
        while (n < this.childLength - 1) {
            stringBuilder.append(this.children[n]);
            stringBuilder.append('|');
            ++n;
        }
        stringBuilder.append(this.children[this.childLength - 1]);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
        int n = 0;
        while (n < this.childLength) {
            if (this.children[n].match(iSGMLParser, node, node2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean optional() {
        int n = this.childLength - 1;
        while (n >= 0) {
            if (this.children[n].optional()) {
                return true;
            }
            --n;
        }
        return false;
    }
}

