/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.config;

import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.eclipse.rdf4j.repository.sparql.config.SPARQLRepositoryConfig;

public class SPARQLRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "openrdf:SPARQLRepository";

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public RepositoryImplConfig getConfig() {
        return new SPARQLRepositoryConfig();
    }

    @Override
    public SPARQLRepository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        SPARQLRepository result;
        if (config instanceof SPARQLRepositoryConfig) {
            SPARQLRepositoryConfig httpConfig = (SPARQLRepositoryConfig)config;
            result = httpConfig.getUpdateEndpointUrl() != null ? new SPARQLRepository(httpConfig.getQueryEndpointUrl(), httpConfig.getUpdateEndpointUrl()) : new SPARQLRepository(httpConfig.getQueryEndpointUrl());
            if (httpConfig.getPassThroughEnabled() != null) {
                result.setPassThroughEnabled(httpConfig.getPassThroughEnabled());
            }
        } else {
            throw new RepositoryConfigException("Invalid configuration class: " + String.valueOf(config.getClass()));
        }
        return result;
    }
}

