/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.endpoint.ManagedRepositoryEndpoint;
import org.eclipse.rdf4j.federated.endpoint.provider.EndpointProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.RemoteRepositoryRepositoryInformation;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.repository.http.HTTPRepository;

public class RemoteRepositoryProvider
implements EndpointProvider<RemoteRepositoryRepositoryInformation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint loadEndpoint(RemoteRepositoryRepositoryInformation repoInfo) throws FedXException {
        String repositoryServer = repoInfo.get("repositoryServer");
        String repositoryName = repoInfo.get("repositoryName");
        if (repositoryServer == null || repositoryName == null) {
            throw new FedXException("Invalid configuration, repositoryServer and repositoryName are required for " + repoInfo.getName());
        }
        try {
            HTTPRepository repo = new HTTPRepository(repositoryServer, repositoryName);
            SharedHttpClientSessionManager httpClientSessionManager = (SharedHttpClientSessionManager)repo.getHttpClientSessionManager();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties().setDefaultRequestConfig(httpClientSessionManager.getDefaultRequestConfig()).setMaxConnTotal(20).setMaxConnPerRoute(20);
            httpClientSessionManager.setHttpClientBuilder(httpClientBuilder);
            try {
                repo.init();
            }
            finally {
                repo.shutDown();
            }
            String location = repositoryServer + "/" + repositoryName;
            EndpointClassification epc = EndpointClassification.Remote;
            ManagedRepositoryEndpoint res = new ManagedRepositoryEndpoint(repoInfo, location, epc, repo);
            res.setEndpointConfiguration(repoInfo.getEndpointConfiguration());
            return res;
        }
        catch (Exception e) {
            throw new FedXException("Repository " + repoInfo.getId() + " could not be initialized: " + e.getMessage(), e);
        }
    }
}

