/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class Export
extends ConsoleCommand {
    @Override
    public String getName() {
        return "export";
    }

    @Override
    public String getHelpShort() {
        return "Exports repository data to a file";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nexport <file>                 Exports the entirey repository to a file\nexport <file> (<uri>|null)... Exports the specified context(s) to a file\n";
    }

    @Override
    public String[] usesSettings() {
        return new String[]{"workdir"};
    }

    public Export(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        super(consoleIO, state, settings);
    }

    @Override
    public void execute(String ... tokens) {
        Resource[] contexts;
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
            return;
        }
        if (tokens.length < 2) {
            this.writeln(this.getHelpLong());
            return;
        }
        String fileName = tokens[1];
        try {
            contexts = Util.getContexts(tokens, 2, repository);
        }
        catch (IllegalArgumentException ioe) {
            this.writeError(ioe.getMessage());
            return;
        }
        this.export(repository, fileName, contexts);
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.get("workdir")).get();
    }

    private void export(Repository repository, String fileName, Resource ... contexts) {
        boolean overwrite;
        Path path = Util.getNormalizedPath(this.getWorkDir(), fileName);
        if (path == null) {
            this.writeError("Invalid file name " + fileName);
            return;
        }
        if (path.toFile().exists() && !(overwrite = this.askProceed("File exists, continue ?", false))) {
            this.writeln("Export aborted");
            return;
        }
        try (RepositoryConnection conn = repository.getConnection();
             BufferedOutputStream w = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            RDFFormat fmt = Rio.getWriterFormatForFileName(fileName).orElseThrow(() -> new UnsupportedRDFormatException("No RDF parser for " + fileName));
            RDFWriter writer = Rio.createWriter(fmt, w);
            long startTime = System.nanoTime();
            this.writeln("Exporting data...");
            conn.export(writer, contexts);
            w.flush();
            long diff = (System.nanoTime() - startTime) / 1000000L;
            this.writeln("Data has been written to file (" + diff + " ms)");
        }
        catch (IOException | UnsupportedRDFormatException e) {
            this.writeError("Failed to export data", e);
        }
    }
}

