/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.util;

import java.util.Objects;
import org.eclipse.rdf4j.query.algebra.Var;

public final class VarUtils {
    public static final String ANON_PATH_PREFIX = "_anon_path_";
    public static final String ANON_PATH_INVERSE_PREFIX = "_anon_path_inverse_";

    private VarUtils() {
    }

    public static boolean sameVar(Var a, Var b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.hasValue() || b.hasValue()) {
            return false;
        }
        return Objects.equals(a.getName(), b.getName());
    }

    public static boolean sameVarOrValue(Var a, Var b) {
        if (a == null || b == null) {
            return false;
        }
        boolean av = a.hasValue();
        boolean bv = b.hasValue();
        if (av && bv) {
            return Objects.equals(a.getValue(), b.getValue());
        }
        if (!av && !bv) {
            return Objects.equals(a.getName(), b.getName());
        }
        return false;
    }

    public static boolean isAnonPathVar(Var v) {
        if (v == null || v.hasValue()) {
            return false;
        }
        String n = v.getName();
        if (n == null || !n.startsWith(ANON_PATH_PREFIX)) {
            return false;
        }
        assert (v.isAnonymous());
        return v.isAnonymous();
    }

    public static boolean isAnonPathInverseVar(Var v) {
        if (v == null || v.hasValue()) {
            return false;
        }
        String n = v.getName();
        if (n == null || !n.startsWith(ANON_PATH_INVERSE_PREFIX)) {
            return false;
        }
        assert (v.isAnonymous());
        return v.isAnonymous();
    }
}

