/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapdb.elsa.ElsaClassCallback;
import org.mapdb.elsa.ElsaClassInfoResolver;
import org.mapdb.elsa.ElsaSerializerBase;
import org.mapdb.elsa.ElsaSerializerPojo;

public class ElsaMaker {
    protected Object[] singletons = null;
    protected List<Class> classes = new ArrayList<Class>();
    protected ElsaClassCallback unknownClassNotification = null;
    protected Map<Class, ElsaSerializerBase.Ser> registeredSers = new HashMap<Class, ElsaSerializerBase.Ser>();
    protected Map<Class, Integer> registeredSerHeaders = new HashMap<Class, Integer>();
    protected Map<Integer, ElsaSerializerBase.Deser> registeredDeser = new HashMap<Integer, ElsaSerializerBase.Deser>();
    protected int objectStack = 0;

    public ElsaMaker singletons(Object ... singletons) {
        this.singletons = singletons;
        return this;
    }

    public ElsaSerializerPojo make() {
        return new ElsaSerializerPojo(this.objectStack, this.singletons, this.registeredSers, this.registeredSerHeaders, this.registeredDeser, this.unknownClassNotification, new ElsaClassInfoResolver.ArrayBased(this.classes.toArray(new Class[0])));
    }

    public ElsaMaker registerClasses(Class ... classes) {
        for (Class clazz : classes) {
            this.classes.add(clazz);
        }
        return this;
    }

    public ElsaMaker unknownClassNotification(ElsaClassCallback callback) {
        this.unknownClassNotification = callback;
        return this;
    }

    public <E> ElsaMaker registerSer(int header, Class<E> clazz, ElsaSerializerBase.Ser<E> ser) {
        if (this.registeredSers.containsKey(clazz)) {
            throw new IllegalArgumentException("Class already has Ser registered: " + clazz);
        }
        this.registeredSers.put(clazz, ser);
        this.registeredSerHeaders.put(clazz, header);
        return this;
    }

    public ElsaMaker registerDeser(int header, ElsaSerializerBase.Deser deser) {
        if (this.registeredDeser.get(header) != null) {
            throw new IllegalArgumentException("Deser for header is already registered: " + header);
        }
        this.registeredDeser.put(header, deser);
        return this;
    }

    public ElsaMaker referenceDisable() {
        this.objectStack = 1;
        return this;
    }

    public ElsaMaker referenceArrayEnable() {
        this.objectStack = 2;
        return this;
    }

    public ElsaMaker referenceHashMapEnable() {
        this.objectStack = 3;
        return this;
    }
}

