/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.function.Supplier;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.AbstractEvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DefaultEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;

public class DefaultEvaluationStrategyFactory
extends AbstractEvaluationStrategyFactory
implements EvaluationStrategyFactory,
FederatedServiceResolverClient {
    private FederatedServiceResolver serviceResolver;
    private Supplier<CollectionFactory> collectionFactorySupplier;

    public DefaultEvaluationStrategyFactory() {
    }

    public DefaultEvaluationStrategyFactory(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    @Override
    public void setCollectionFactory(Supplier<CollectionFactory> collectionFactory) {
        this.collectionFactorySupplier = collectionFactory;
    }

    @Override
    public EvaluationStrategy createEvaluationStrategy(Dataset dataset, TripleSource tripleSource, EvaluationStatistics evaluationStatistics) {
        DefaultEvaluationStrategy strategy = new DefaultEvaluationStrategy(tripleSource, dataset, this.serviceResolver, this.getQuerySolutionCacheThreshold(), evaluationStatistics, this.isTrackResultSize());
        this.getOptimizerPipeline().ifPresent(strategy::setOptimizerPipeline);
        strategy.setCollectionFactory(this.collectionFactorySupplier);
        return strategy;
    }
}

