/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.io.NioFile;
import org.eclipse.rdf4j.sail.nativerdf.AbstractRecordCache;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

final class SequentialRecordCache
extends AbstractRecordCache {
    private static final AtomicLong TEMP_FILE_COUNTER = new AtomicLong();
    private static final String TEMP_FILE_PREFIX = "txncache" + UUID.randomUUID().toString().replace("-", "");
    private static final String TEMP_FILE_SUFFIX = ".dat";
    private static final EnumSet<StandardOpenOption> FILE_OPEN_OPTIONS = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DELETE_ON_CLOSE);
    private static final byte[] MAGIC_NUMBER = new byte[]{115, 114, 99};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final int HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final int recordSize;
    private long currentSize;
    private long extendedSize;
    private final NioFile nioFile;

    public SequentialRecordCache(File cacheDir, int recordSize) throws IOException {
        this(cacheDir, recordSize, Long.MAX_VALUE);
    }

    public SequentialRecordCache(File cacheDir, int recordSize, long maxRecords) throws IOException {
        super(maxRecords);
        this.recordSize = recordSize;
        Path path = Paths.get(cacheDir.getCanonicalPath(), TEMP_FILE_PREFIX + TEMP_FILE_COUNTER.incrementAndGet() + TEMP_FILE_SUFFIX);
        this.nioFile = new NioFile(path, FILE_OPEN_OPTIONS);
        this.append(MAGIC_NUMBER);
        this.append(new byte[]{1});
    }

    private void append(byte[] data) throws IOException {
        if (this.currentSize >= this.extendedSize - (long)this.recordSize) {
            long newExtendedSize = ((this.currentSize + (long)this.recordSize) / 4096L + 1L) * 4096L;
            assert (newExtendedSize > this.extendedSize);
            int bytesToWrite = (int)(newExtendedSize - this.extendedSize);
            this.nioFile.writeBytes(new byte[bytesToWrite], this.currentSize);
            this.extendedSize += (long)bytesToWrite;
        }
        this.nioFile.writeBytes(data, this.currentSize);
        this.currentSize += (long)data.length;
    }

    @Override
    public void discard() throws IOException {
        this.nioFile.delete();
    }

    @Override
    protected void clearInternal() throws IOException {
        this.nioFile.truncate((long)HEADER_LENGTH);
        this.extendedSize = this.currentSize = this.nioFile.size();
    }

    @Override
    protected void storeRecordInternal(byte[] data) throws IOException {
        this.append(data);
    }

    @Override
    protected RecordIterator getRecordsInternal() {
        return new RecordCacheIterator();
    }

    protected class RecordCacheIterator
    implements RecordIterator {
        private long position = HEADER_LENGTH;
        private long readAheadBufferPosition = HEADER_LENGTH;
        private final ByteBuffer readAheadBuffer;

        protected RecordCacheIterator() {
            this.readAheadBuffer = ByteBuffer.allocate(4096 + SequentialRecordCache.this.recordSize);
            this.readAheadBuffer.position(this.readAheadBuffer.limit());
        }

        private void fillReadAheadBuffer() throws IOException {
            while (this.readAheadBuffer.limit() - this.readAheadBuffer.position() < SequentialRecordCache.this.recordSize && SequentialRecordCache.this.currentSize > this.readAheadBufferPosition) {
                this.readAheadBuffer.compact();
                if (this.readAheadBufferPosition == (long)HEADER_LENGTH) {
                    this.readAheadBuffer.limit(this.readAheadBuffer.limit() - HEADER_LENGTH);
                } else if (this.readAheadBufferPosition % 4096L != 0L) {
                    this.readAheadBuffer.limit(4096 - (int)(this.readAheadBufferPosition % 4096L) + this.readAheadBuffer.position());
                } else {
                    this.readAheadBuffer.limit(4096 + this.readAheadBuffer.position());
                }
                int read = SequentialRecordCache.this.nioFile.read(this.readAheadBuffer, this.readAheadBufferPosition);
                this.readAheadBufferPosition += (long)read;
                this.readAheadBuffer.flip();
                if (this.readAheadBufferPosition > SequentialRecordCache.this.currentSize) {
                    this.readAheadBuffer.limit((int)((long)this.readAheadBuffer.limit() - (this.readAheadBufferPosition - SequentialRecordCache.this.currentSize)));
                    this.readAheadBufferPosition = SequentialRecordCache.this.currentSize;
                }
                if (read > 0) continue;
                break;
            }
        }

        @Override
        public byte[] next() throws IOException {
            this.fillReadAheadBuffer();
            if (!this.readAheadBuffer.hasRemaining()) {
                return null;
            }
            byte[] bytes = new byte[SequentialRecordCache.this.recordSize];
            this.readAheadBuffer.get(bytes);
            this.position += (long)SequentialRecordCache.this.recordSize;
            return bytes;
        }

        @Override
        public void set(byte[] value) throws IOException {
            if (this.position >= (long)(HEADER_LENGTH + SequentialRecordCache.this.recordSize) && this.position <= SequentialRecordCache.this.currentSize) {
                SequentialRecordCache.this.nioFile.writeBytes(value, this.position - (long)SequentialRecordCache.this.recordSize);
            }
        }

        @Override
        public void close() {
        }
    }
}

