/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trig;

import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TriGParser
extends TurtleParser {
    private Resource context;

    public TriGParser() {
    }

    public TriGParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIG;
    }

    protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
        StringBuilder sb = new StringBuilder(8);
        do {
            int c;
            if ((c = this.readCodePoint()) == -1 || TurtleUtil.isWhitespace((int)c)) {
                this.unread(c);
                break;
            }
            sb.append((char)c);
        } while (sb.length() < 8);
        String directive = sb.toString();
        if (directive.startsWith("@")) {
            this.parseDirective(directive);
            this.skipWSC();
            this.verifyCharacterOrFail(this.readCodePoint(), ".");
        } else if (directive.length() >= 6 && directive.substring(0, 6).equalsIgnoreCase("prefix") || directive.length() >= 4 && directive.substring(0, 4).equalsIgnoreCase("base")) {
            this.parseDirective(directive);
            this.skipWSC();
        } else if (directive.length() >= 6 && directive.substring(0, 5).equalsIgnoreCase("GRAPH") && directive.substring(5, 6).equals(":")) {
            this.unread(directive);
            this.parseGraph();
        } else if (directive.length() >= 5 && directive.substring(0, 5).equalsIgnoreCase("GRAPH")) {
            this.skipWSC();
            this.parseGraph();
            if (this.getContext() == null) {
                this.reportFatalError("Missing GRAPH label or subject");
            }
        } else {
            this.unread(directive);
            this.parseGraph();
        }
    }

    protected void parseGraph() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.readCodePoint();
        int c2 = this.peekCodePoint();
        Resource contextOrSubject = null;
        boolean foundContextOrSubject = false;
        if (c == 91) {
            this.skipWSC();
            c2 = this.readCodePoint();
            if (c2 == 93) {
                contextOrSubject = this.createNode();
                foundContextOrSubject = true;
                this.skipWSC();
            } else {
                this.unread(c2);
                this.unread(c);
            }
            c = this.readCodePoint();
        } else if (c == 60 || TurtleUtil.isPrefixStartChar((int)c) || c == 58 && c2 != 45 || c == 95 && c2 == 58) {
            this.unread(c);
            Value value = this.parseValue();
            if (value instanceof Resource) {
                contextOrSubject = (Resource)value;
                foundContextOrSubject = true;
            } else {
                this.reportFatalError("Illegal graph name: " + String.valueOf(value));
            }
            this.skipWSC();
            c = this.readCodePoint();
        } else {
            this.setContext(null);
        }
        if (c == 123) {
            this.setContext(contextOrSubject);
            c = this.skipWSC();
            if (c != 125) {
                this.parseTriples();
                c = this.skipWSC();
                while (c == 46) {
                    this.readCodePoint();
                    c = this.skipWSC();
                    if (c == 125) break;
                    this.parseTriples();
                    c = this.skipWSC();
                }
                this.verifyCharacterOrFail(c, "}");
            }
        } else {
            this.setContext(null);
            if (foundContextOrSubject) {
                this.subject = contextOrSubject;
                this.unread(c);
                this.parsePredicateObjectList();
            } else {
                this.unread(c);
                this.parseTriples();
            }
        }
        this.readCodePoint();
    }

    protected void parseTriples() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peekCodePoint();
        if (c == 91) {
            c = this.readCodePoint();
            this.skipWSC();
            c = this.peekCodePoint();
            if (c == 93) {
                c = this.readCodePoint();
                this.subject = this.createNode();
                this.skipWSC();
                this.parsePredicateObjectList();
            } else {
                this.unread(91);
                this.subject = this.parseImplicitBlank();
            }
            this.skipWSC();
            c = this.peekCodePoint();
            if (c != 46 && c != 125) {
                this.parsePredicateObjectList();
            }
        } else {
            this.parseSubject();
            this.skipWSC();
            this.parsePredicateObjectList();
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    protected void reportStatement(Resource subj, IRI pred, Value obj) throws RDFParseException, RDFHandlerException {
        Statement st = this.createStatement(subj, pred, obj, this.getContext());
        if (this.rdfHandler != null) {
            this.rdfHandler.handleStatement(st);
        }
    }

    protected void setContext(Resource context) {
        this.context = context;
    }

    protected Resource getContext() {
        return this.context;
    }
}

