/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.RDFParserHelper;
import org.eclipse.rdf4j.rio.helpers.RDFStarDecodingValueFactory;

public abstract class AbstractRDFParser
implements RDFParser {
    private static final String uniqueIdPrefix = UUID.randomUUID().toString().replace("-", "");
    private static final AtomicLong uniqueIdSuffix = new AtomicLong();
    private final MessageDigest md5;
    protected RDFHandler rdfHandler;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;
    protected ValueFactory valueFactory;
    private ValueFactory originalValueFactory;
    private ParsedIRI baseURI;
    private String skolemOrigin;
    private ParsedIRI parsedSkolemOrigin;
    private String nextBNodePrefix;
    private final Map<String, String> namespaceTable;
    private ParserConfig parserConfig;

    protected AbstractRDFParser() {
        this((ValueFactory)SimpleValueFactory.getInstance());
    }

    protected AbstractRDFParser(ValueFactory valueFactory) {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.namespaceTable = new HashMap<String, String>(16);
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.setValueFactory(valueFactory);
        this.setParserConfig(new ParserConfig());
    }

    @Override
    public RDFParser setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
        this.originalValueFactory = valueFactory;
        return this;
    }

    @Override
    public RDFParser setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
        return this;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    @Override
    public RDFParser setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
        return this;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    @Override
    public RDFParser setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
        return this;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    @Override
    public RDFParser setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        this.initializeNamespaceTableFromConfiguration();
        return this;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet();
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        result.add(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        result.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
        result.add(BasicParserSettings.DATATYPE_HANDLERS);
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        result.add(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        result.add(BasicParserSettings.NORMALIZE_LANGUAGE_TAGS);
        result.add(BasicParserSettings.LANGUAGE_HANDLERS);
        result.add(BasicParserSettings.VERIFY_RELATIVE_URIS);
        result.add(BasicParserSettings.VERIFY_URI_SYNTAX);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(BasicParserSettings.NAMESPACES);
        result.add(BasicParserSettings.SKOLEMIZE_ORIGIN);
        return result;
    }

    @Override
    public <T> RDFParser set(RioSetting<T> setting, T value) {
        this.getParserConfig().set((RioSetting)setting, (Object)value);
        return this;
    }

    @Override
    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)preserveBNodeIDs);
    }

    public boolean preserveBNodeIDs() {
        return this.parserConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    protected void setBaseURI(String uriSpec) {
        if (this.baseURI == null || !this.baseURI.toString().equals(uriSpec)) {
            this.baseURI = ParsedIRI.create((String)uriSpec);
        }
    }

    protected void setBaseURI(ParsedIRI baseURI) {
        this.setBaseURI(baseURI.toString());
    }

    protected void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
    }

    protected String getNamespace(String prefix) throws RDFParseException {
        if (this.namespaceTable.containsKey(prefix)) {
            return this.namespaceTable.get(prefix);
        }
        Object msg = "Namespace prefix '" + prefix + "' used but not defined";
        if ("".equals(prefix)) {
            msg = "Default namespace used but not defined";
        }
        this.reportFatalError((String)msg);
        throw new RDFParseException((String)msg);
    }

    protected void clear() {
        this.baseURI = null;
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.namespaceTable.clear();
        this.valueFactory = this.getParserConfig().get(BasicParserSettings.PROCESS_ENCODED_RDF_STAR) != false ? new RDFStarDecodingValueFactory(this.originalValueFactory) : this.originalValueFactory;
        this.initializeNamespaceTableFromConfiguration();
    }

    protected void initializeNamespaceTableFromConfiguration() {
        for (Namespace aNS : this.getParserConfig().get(BasicParserSettings.NAMESPACES)) {
            this.namespaceTable.put(aNS.getPrefix(), aNS.getName());
        }
    }

    @Deprecated
    protected void clearBNodeIDMap() {
        this.clear();
    }

    protected IRI resolveURI(String uriSpec) throws RDFParseException {
        if (uriSpec.indexOf(58) < 0) {
            if (this.baseURI == null) {
                this.reportFatalError("Unable to resolve URIs, no base URI has been set");
            }
            if (this.getParserConfig().get(BasicParserSettings.VERIFY_RELATIVE_URIS).booleanValue() && !uriSpec.isEmpty() && !uriSpec.startsWith("#") && this.baseURI.isOpaque()) {
                this.reportError("Relative URI '" + uriSpec + "' cannot be resolved using the opaque base URI '" + this.baseURI + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_RELATIVE_URIS);
            }
            return this.createURI(this.baseURI.resolve(uriSpec));
        }
        return this.createURI(uriSpec);
    }

    protected IRI createURI(String uri) throws RDFParseException {
        if (this.getParserConfig().get(BasicParserSettings.VERIFY_URI_SYNTAX).booleanValue()) {
            try {
                new ParsedIRI(uri);
            }
            catch (URISyntaxException e) {
                this.reportError(e.getMessage(), (RioSetting<Boolean>)BasicParserSettings.VERIFY_URI_SYNTAX);
                return null;
            }
        }
        try {
            return this.valueFactory.createIRI(uri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Resource createNode() throws RDFParseException {
        ParsedIRI skolem = this.getCachedSkolemOrigin();
        try {
            if (this.preserveBNodeIDs() || skolem == null) {
                return this.valueFactory.createBNode();
            }
            String nodeId = this.valueFactory.createBNode().getID();
            String path = "/.well-known/genid/" + this.nextBNodePrefix + nodeId;
            String iri = skolem.resolve(path);
            return this.valueFactory.createIRI(iri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Resource createNode(String nodeID) throws RDFParseException {
        ParsedIRI skolem;
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        String toAppend = nodeID;
        if (nodeID.length() > 32) {
            byte[] chars = nodeID.getBytes(StandardCharsets.UTF_8);
            toAppend = Hex.encodeHexString((byte[])this.md5.digest(chars), (boolean)false);
        }
        if ((skolem = this.getCachedSkolemOrigin()) == null) {
            return this.valueFactory.createBNode("genid-" + this.nextBNodePrefix + toAppend);
        }
        String path = "/.well-known/genid/" + this.nextBNodePrefix + toAppend;
        String iri = skolem.resolve(path);
        return this.valueFactory.createIRI(iri);
    }

    @Deprecated
    protected BNode createBNode() throws RDFParseException {
        try {
            return this.valueFactory.createBNode();
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    @Deprecated
    protected BNode createBNode(String nodeID) throws RDFParseException {
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        String toAppend = nodeID;
        if (nodeID.length() > 32) {
            byte[] chars = nodeID.getBytes(StandardCharsets.UTF_8);
            toAppend = Hex.encodeHexString((byte[])this.md5.digest(chars), (boolean)false);
        }
        return this.valueFactory.createBNode("genid-" + this.nextBNodePrefix + toAppend);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype, long lineNo, long columnNo) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory, lineNo, columnNo);
    }

    protected Literal createLiteral(String label, String lang, CoreDatatype datatype, long lineNo, long columnNo) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype.getIri(), this.getParserConfig(), this.getParseErrorListener(), this.valueFactory, lineNo, columnNo);
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj, Resource context) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj, context);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected void reportLocation(long lineNo, long columnNo) {
        if (this.locationListener != null) {
            this.locationListener.parseLocationUpdate(lineNo, columnNo);
        }
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, -1L, -1L);
    }

    protected void reportWarning(String msg, long lineNo, long columnNo) {
        if (this.errListener != null) {
            this.errListener.warning(msg, lineNo, columnNo);
        }
    }

    protected void reportError(String msg, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, -1L, -1L, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, this.getParseErrorListener());
    }

    protected void reportFatalError(String msg, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(String message, Exception e, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(message, e, lineNo, columnNo, this.getParseErrorListener());
    }

    private String createUniqueBNodePrefix() {
        return uniqueIdPrefix + uniqueIdSuffix.incrementAndGet() + "-";
    }

    private ParsedIRI getCachedSkolemOrigin() {
        String origin = this.getParserConfig().get(BasicParserSettings.SKOLEMIZE_ORIGIN);
        if (origin == null || origin.isEmpty()) {
            if (this.skolemOrigin != null) {
                this.skolemOrigin = null;
                this.parsedSkolemOrigin = null;
            }
            return null;
        }
        if (this.skolemOrigin != null && origin.equals(this.skolemOrigin)) {
            return this.parsedSkolemOrigin;
        }
        this.skolemOrigin = origin;
        this.parsedSkolemOrigin = ParsedIRI.create((String)origin);
        return this.parsedSkolemOrigin;
    }
}

