/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class ByteArrayVol
extends Volume {
    public static final VolumeFactory FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            return new ByteArrayVol(sliceShift, initSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return false;
        }

        @Override
        public boolean handlesReadonly() {
            return false;
        }
    };
    protected final ReentrantLock growLock = new ReentrantLock();
    protected final int sliceShift;
    protected final int sliceSizeModMask;
    protected final int sliceSize;
    protected volatile byte[][] slices = new byte[0][];

    public ByteArrayVol() {
        this(20, 0L);
    }

    public ByteArrayVol(int sliceShift, long initSize) {
        this.sliceShift = sliceShift;
        this.sliceSize = 1 << sliceShift;
        this.sliceSizeModMask = this.sliceSize - 1;
        if (initSize != 0L) {
            this.ensureAvailable(initSize);
        }
    }

    protected final byte[] getSlice(long offset) {
        int pos = (int)(offset >>> this.sliceShift);
        byte[][] slices = this.slices;
        if (pos >= slices.length) {
            throw new DBException.VolumeEOF("offset points beyond slices");
        }
        return slices[pos];
    }

    @Override
    public final void ensureAvailable(long offset) {
        int slicePos = (int)((offset = DataIO.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
        if (slicePos < this.slices.length) {
            return;
        }
        this.growLock.lock();
        try {
            if (slicePos <= this.slices.length) {
                return;
            }
            int oldSize = this.slices.length;
            byte[][] slices2 = this.slices;
            slices2 = (byte[][])Arrays.copyOf(slices2, slicePos);
            for (int pos = oldSize; pos < slices2.length; ++pos) {
                slices2[pos] = new byte[this.sliceSize];
            }
            this.slices = slices2;
        }
        catch (OutOfMemoryError e) {
            throw new DBException.OutOfMemory(e);
        }
        finally {
            this.growLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long size) {
        int maxSize = 1 + (int)(size >>> this.sliceShift);
        if (maxSize == this.slices.length) {
            return;
        }
        if (maxSize > this.slices.length) {
            this.ensureAvailable(size);
            return;
        }
        this.growLock.lock();
        try {
            if (maxSize >= this.slices.length) {
                return;
            }
            this.slices = (byte[][])Arrays.copyOf(this.slices, maxSize);
        }
        finally {
            this.growLock.unlock();
        }
    }

    @Override
    public void putLong(long offset, long v) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        DataIO.putLong(buf, pos, v);
    }

    @Override
    public void putInt(long offset, int value) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        buf[pos++] = (byte)(0xFF & value >> 24);
        buf[pos++] = (byte)(0xFF & value >> 16);
        buf[pos++] = (byte)(0xFF & value >> 8);
        buf[pos++] = (byte)(0xFF & value);
    }

    @Override
    public void putByte(long offset, byte value) {
        byte[] b = this.getSlice(offset);
        b[(int)(offset & (long)this.sliceSizeModMask)] = value;
    }

    @Override
    public void putData(long offset, byte[] src, int srcPos, int srcSize) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        System.arraycopy(src, srcPos, buf, pos, srcSize);
    }

    @Override
    public void putData(long offset, ByteBuffer buf) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] dst = this.getSlice(offset);
        buf.get(dst, pos, buf.remaining());
    }

    @Override
    public void copyTo(long inputOffset, Volume target, long targetOffset, long size) {
        int pos = (int)(inputOffset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(inputOffset);
        target.putData(targetOffset, buf, pos, (int)size);
    }

    @Override
    public void putDataOverlap(long offset, byte[] data, int pos, int len) {
        boolean overlap;
        boolean bl = overlap = offset >>> this.sliceShift != offset + (long)len >>> this.sliceShift;
        if (overlap) {
            while (len > 0) {
                byte[] b = this.getSlice(offset);
                int pos2 = (int)(offset & (long)this.sliceSizeModMask);
                int toPut = Math.min(len, this.sliceSize - pos2);
                System.arraycopy(data, pos, b, pos2, toPut);
                pos += toPut;
                len -= toPut;
                offset += (long)toPut;
            }
        } else {
            this.putData(offset, data, pos, len);
        }
    }

    @Override
    public DataInput2 getDataInputOverlap(long offset, int size) {
        boolean overlap;
        boolean bl = overlap = offset >>> this.sliceShift != offset + (long)size >>> this.sliceShift;
        if (overlap) {
            byte[] bb = new byte[size];
            int origLen = size;
            while (size > 0) {
                byte[] b = this.getSlice(offset);
                int pos = (int)(offset & (long)this.sliceSizeModMask);
                int toPut = Math.min(size, this.sliceSize - pos);
                System.arraycopy(b, pos, bb, origLen - size, toPut);
                size -= toPut;
                offset += (long)toPut;
            }
            return new DataInput2.ByteArray(bb);
        }
        return this.getDataInput(offset, size);
    }

    @Override
    public void clear(long startOffset, long endOffset) {
        if (startOffset >>> this.sliceShift != endOffset - 1L >>> this.sliceShift) {
            throw new AssertionError();
        }
        byte[] buf = this.getSlice(startOffset);
        int start = (int)(startOffset & (long)this.sliceSizeModMask);
        int end = (int)((long)start + (endOffset - startOffset));
        for (int pos = start; pos < end; pos += CLEAR.length) {
            System.arraycopy(CLEAR, 0, buf, pos, Math.min(CLEAR.length, end - pos));
        }
    }

    @Override
    public long getLong(long offset) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        return DataIO.getLong(buf, pos);
    }

    @Override
    public int getInt(long offset) {
        int pos;
        byte[] buf = this.getSlice(offset);
        int end = pos + 4;
        int ret = 0;
        for (pos = (int)(offset & (long)this.sliceSizeModMask); pos < end; ++pos) {
            ret = ret << 8 | buf[pos] & 0xFF;
        }
        return ret;
    }

    @Override
    public byte getByte(long offset) {
        byte[] b = this.getSlice(offset);
        return b[(int)(offset & (long)this.sliceSizeModMask)];
    }

    @Override
    public DataInput2 getDataInput(long offset, int size) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        return new DataInput2.ByteArray(buf, pos);
    }

    @Override
    public void getData(long offset, byte[] bytes, int bytesPos, int length) {
        int pos = (int)(offset & (long)this.sliceSizeModMask);
        byte[] buf = this.getSlice(offset);
        System.arraycopy(buf, pos, bytes, bytesPos, length);
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.slices = null;
    }

    @Override
    public void sync() {
    }

    @Override
    public int sliceSize() {
        return this.sliceSize;
    }

    @Override
    public boolean isSliced() {
        return true;
    }

    @Override
    public long length() {
        return (long)this.slices.length * (long)this.sliceSize;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean getFileLocked() {
        return false;
    }
}

