/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.Q7ExternalLaunchDelegate;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;

public class Q7LaunchDelegateUtils {
    private static final Predicate<IPluginModelBase> isSimpleConfigurator = new Predicate<IPluginModelBase>(){

        public boolean apply(IPluginModelBase input) {
            return "org.eclipse.equinox.simpleconfigurator".equals(Q7LaunchDelegateUtils.id(input));
        }
    };
    private static List<String> EXCLUDE = Arrays.asList("org.eclipse.osgi");
    private static final Predicate<Object> keepBundle = new Predicate<Object>(){

        public boolean apply(Object input) {
            return !EXCLUDE.contains(Q7LaunchDelegateUtils.id((IPluginModelBase)input));
        }
    };
    private static final String DEFAULT = "default";

    public static IStatus validateForLaunch(ITargetPlatformHelper target, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validating bundles", (int)3);
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            IStatus status = target.resolve((IProgressMonitor)sm.split(1));
            if (status.matches(12)) {
                return status;
            }
            wc = Q7LaunchingUtil.createLaunchConfiguration(target);
            StringBuilder message = new StringBuilder();
            OSArchitecture architecture = target.detectArchitecture(message);
            if (architecture == null || architecture == OSArchitecture.Unknown) {
                return Status.error((String)message.toString());
            }
            if (!Q7ExternalLaunchDelegate.updateJVM(wc, architecture, target)) {
                return Status.error((String)String.format("No compatible JRE is configured. Architecture: %s, incompatible environments: %s", new Object[]{architecture, target.getIncompatibleExecutionEnvironments()}));
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        LaunchValidationOperation validation = new LaunchValidationOperation((ILaunchConfiguration)wc, target.getModels().map(ITargetPlatformHelper.Model::model).collect(Collectors.toSet())){

            protected IExecutionEnvironment[] getMatchingEnvironments() throws CoreException {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
                return envs;
            }
        };
        try {
            wc.delete();
        }
        catch (CoreException e1) {
            return e1.getStatus();
        }
        try {
            StringBuilder b = new StringBuilder();
            validation.run((IProgressMonitor)sm.split(1));
            Map input = validation.getInput();
            for (Map.Entry e : input.entrySet()) {
                Object value = e.getKey();
                if (!(value instanceof ResolverError)) continue;
                b.append(value.toString()).append("\n");
            }
            if (b.length() > 0) {
                return Status.error((String)("Bundle validation failed: " + b.toString()));
            }
            IProgressMonitor.done((IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static String getEntry(IPluginModelBase bundle, String startLevel) {
        StringBuilder result = new StringBuilder("reference:");
        result.append(LaunchConfigurationHelper.getBundleURL((IPluginModelBase)bundle, (boolean)false));
        result.append(startLevel);
        return result.toString();
    }

    private static IPluginModelBase getSimpleConfigurator(Map<String, Object> bundles) {
        return (IPluginModelBase)bundles.get("org.eclipse.equinox.simpleconfigurator");
    }

    private static IPluginModelBase findSimpleConfigurator(Iterable<IPluginModelBase> plugins) {
        return (IPluginModelBase)Iterables.find(plugins, isSimpleConfigurator, null);
    }

    public static String computeOSGiBundles(Map<String, Object> bundles, Map<Object, String> bundlesWithStartLevels) {
        return Q7LaunchDelegateUtils.computeOSGiBundles(bundles, bundlesWithStartLevels, 4);
    }

    public static String computeOSGiBundles(Map<IPluginModelBase, BundleStart> bundles) {
        return Q7LaunchDelegateUtils.computeOSGiBundles(bundles, 4);
    }

    public static String computeOSGiBundles(Map<IPluginModelBase, BundleStart> bundles, int defaultStartLevel) {
        IPluginModelBase sc = Q7LaunchDelegateUtils.findSimpleConfigurator(bundles.keySet());
        if (sc != null) {
            return Q7LaunchDelegateUtils.getEntry(sc, "@1:start");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<IPluginModelBase, BundleStart> entry : bundles.entrySet()) {
            if (EXCLUDE.contains(Q7LaunchDelegateUtils.id(entry.getKey()))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(Q7LaunchDelegateUtils.getEntry(entry.getKey(), entry.getValue().toOsgiString(defaultStartLevel)));
        }
        return sb.toString();
    }

    private static final String resolveStartLevel(String sl, int defaultStartLevel) {
        int sep = sl.indexOf(58);
        String levelStr = sep == -1 ? sl : sl.substring(0, sep);
        String startStr = sep == -1 ? DEFAULT : sl.substring(sep + 1);
        boolean defaultLevel = DEFAULT.equals(levelStr);
        boolean defaultStart = DEFAULT.equals(startStr);
        if (defaultLevel && defaultStart) {
            return "";
        }
        if (defaultStart) {
            return "@" + levelStr;
        }
        String actualLevelStr = defaultLevel ? Integer.toString(defaultStartLevel) : levelStr;
        String actualStartStr = Boolean.parseBoolean(startStr) ? ":start" : "";
        return "@" + actualLevelStr + actualStartStr;
    }

    public static String computeOSGiBundles(Map<String, Object> bundles, final Map<Object, String> bundlesWithStartLevels, final int defaultStartLevel) {
        IPluginModelBase simpleConfigurator = Q7LaunchDelegateUtils.getSimpleConfigurator(bundles);
        if (simpleConfigurator != null) {
            return Q7LaunchDelegateUtils.getEntry(simpleConfigurator, "@1:start");
        }
        return Joiner.on((String)",").join(Iterables.transform((Iterable)Iterables.filter(bundles.values(), keepBundle), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                IPluginModelBase plugin = (IPluginModelBase)input;
                return Q7LaunchDelegateUtils.getEntry(plugin, Q7LaunchDelegateUtils.resolveStartLevel((String)bundlesWithStartLevels.get(plugin), defaultStartLevel));
            }
        }));
    }

    public static String id(IPluginModelBase plugin) {
        return plugin.getPluginBase().getId();
    }

    public static void setDelegateFields(EclipseApplicationLaunchConfiguration delegate, Map<IPluginModelBase, String> models, Map<String, List<IPluginModelBase>> allBundles) throws CoreException {
        try {
            Field field = EclipseApplicationLaunchConfiguration.class.getDeclaredField("fModels");
            field.setAccessible(true);
            field.set(delegate, models);
            field = EclipseApplicationLaunchConfiguration.class.getDeclaredField("fAllBundles");
            field.setAccessible(true);
            field.set(delegate, allBundles);
        }
        catch (IllegalAccessException e) {
            throw new CoreException(RcpttPlugin.createStatus((String)"Failed to inject bundles", (Throwable)e));
        }
        catch (SecurityException e) {
            throw new CoreException(RcpttPlugin.createStatus((String)"Failed to inject bundles", (Throwable)e));
        }
        catch (NoSuchFieldException e) {
            throw new CoreException(RcpttPlugin.createStatus((String)"Failed to inject bundles", (Throwable)e));
        }
    }

    public static Map<IPluginModelBase, String> getEclipseApplicationModels(EclipseApplicationLaunchConfiguration delegate) {
        try {
            Field field = EclipseApplicationLaunchConfiguration.class.getDeclaredField("fModels");
            field.setAccessible(true);
            return (Map)field.get(delegate);
        }
        catch (Throwable e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
            return null;
        }
    }

    public static File getWorkingDirectory(File autLocation) {
        if (!Platform.getOS().equals("macosx")) {
            return autLocation;
        }
        if (autLocation == null || !autLocation.exists() || !autLocation.isDirectory()) {
            return autLocation;
        }
        File[] fileArray = autLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File result;
            File child = fileArray[n2];
            if (child.isDirectory() && child.getName().endsWith(".app") && (result = new File(new File(child, "Contents"), "MacOS")).exists()) {
                return result;
            }
            ++n2;
        }
        return autLocation;
    }

    public static String getAUTArgs(String[] args) {
        return Q7LaunchDelegateUtils.getAUTArgs(args == null ? Collections.emptyList() : Arrays.asList(args));
    }

    public static String getJoinedVMArgs(ITargetPlatformHelper aut, Collection<String> userArgs) {
        return Q7LaunchDelegateUtils.joinCommandArgs(Q7LaunchDelegateUtils.getVMArgs(aut, userArgs));
    }

    public static List<String> getVMArgs(ITargetPlatformHelper aut, Collection<String> userArgs) {
        String iniArgs = aut.getIniVMArgs();
        if (iniArgs == null) {
            iniArgs = LaunchArgumentsHelper.getInitialVMArguments().trim();
        }
        Object[] parsedIniArgs = DebugPlugin.parseArguments((String)Strings.nullToEmpty((String)iniArgs));
        ArrayList args = Lists.newArrayList((Object[])parsedIniArgs);
        if (userArgs != null) {
            args.addAll(userArgs);
        }
        return UpdateVMArgs.updateAttr(args);
    }

    private static void addIfAbsent(Collection<String> arguments, String key, String value) {
        Preconditions.checkNotNull((Object)key);
        if (!Iterables.any(arguments, (Predicate)Predicates.equalTo((Object)key))) {
            arguments.add(key);
            if (value != null) {
                arguments.add(value);
            }
        }
    }

    public static String getAUTArgs(Collection<String> userArgs) {
        ArrayList<String> allArgs = new ArrayList<String>();
        if (userArgs != null) {
            allArgs.addAll(userArgs);
        }
        Q7LaunchDelegateUtils.addIfAbsent(allArgs, "-os", "${target.os}");
        Q7LaunchDelegateUtils.addIfAbsent(allArgs, "-arch", "${target.arch}");
        Q7LaunchDelegateUtils.addIfAbsent(allArgs, "-consoleLog", null);
        return Q7LaunchDelegateUtils.joinCommandArgs(allArgs);
    }

    public static String joinCommandArgs(Collection<String> args) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        return Joiner.on((char)' ').join((Iterable)Collections2.transform(args, UpdateVMArgs.ESCAPE));
    }

    public static String escapeCommandArg(String arg) {
        return UpdateVMArgs.escapeCommandArg(arg);
    }

    public static String joinCommandArgs(String[] args) {
        return Q7LaunchDelegateUtils.joinCommandArgs(args == null ? Collections.emptyList() : Arrays.asList(args));
    }
}

