/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<K, V> {
    private final ConcurrentHashMap<K, EntryRef<K, V>> map = new ConcurrentHashMap();
    private final ReferenceQueue<Entry<V>> referenceQueue = new ReferenceQueue();

    public void addEntry(K key, V toCache) {
        this.addEntry(key, toCache, 0L);
    }

    private void cleanup() {
        EntryRef e = null;
        while ((e = (EntryRef)this.referenceQueue.poll()) != null) {
            this.map.remove(e.key);
        }
    }

    public Entry<V> addEntry(K key, V toCache, long timestamp) {
        this.cleanup();
        Entry<V> e = new Entry<V>(toCache, timestamp);
        this.map.put(key, new EntryRef<K, V>(key, e, this.referenceQueue));
        return e;
    }

    public Entry<V> getEntry(K key) {
        this.cleanup();
        SoftReference ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        return (Entry)ref.get();
    }

    public void clear() {
        this.map.clear();
    }

    public record Entry<V>(V cached, long timestamp) {
        public V getCached() {
            return this.cached;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class EntryRef<K, V>
    extends SoftReference<Entry<V>> {
        private final K key;

        public EntryRef(K key, Entry<V> entry, ReferenceQueue<Entry<V>> queue) {
            super(entry, queue);
            this.key = key;
        }
    }
}

