/*******************************************************************************
 * Copyright (c) 2009, 2019 Xored Software Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Xored Software Inc - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.rcptt.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.Q7Launcher;

public class StopAction extends Action {

    public StopAction() {
        setToolTipText(Messages.StopAction_ToolTip);
        setImageDescriptor(Images.getImageDescriptor(Images.STOP));
        setDisabledImageDescriptor(Images.getImageDescriptor(Images.STOP_D));
        setText("&Stop");
    }

    public void updateEnablement(IExecutionSession session) {
        if (session != null) {
            setEnabled(session.isRunning());
        } else {
            setEnabled(false);
        }
    }

    @Override
    public void run() {
		getLauncher().stop(
				new Status(IStatus.CANCEL, RcpttPlugin.PLUGIN_ID, "Execution is stopped from Execution view"));
        updateEnablement(null);
    }

    private Q7Launcher getLauncher() {
        return Q7Launcher.getInstance();
    }

}
